/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.events;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormChoiceComponentUpdatingBehavior;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public abstract class EventSelectionPanel
extends Panel {
    private static final long serialVersionUID = 752233163798301002L;
    private final Set<String> selected = new HashSet<String>();

    public EventSelectionPanel(String id, final EventCategory eventCategoryTO, IModel<List<String>> model) {
        super(id);
        this.setOutputMarkupId(true);
        List<String> events = EventSelectionPanel.getEvents(eventCategoryTO);
        this.selected.addAll((Collection)model.getObject());
        final CheckGroup successGroup = new CheckGroup("successGroup", this.selected);
        successGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                HashSet<String> toBeRemoved = new HashSet<String>();
                HashSet<String> toBeAdded = new HashSet<String>();
                EventSelectionPanel.getEvents(eventCategoryTO).forEach(event -> {
                    String eventString = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)event, (AuditElements.Result)AuditElements.Result.SUCCESS);
                    if (((Collection)successGroup.getModelObject()).contains(eventString)) {
                        toBeAdded.add(eventString);
                    } else {
                        toBeRemoved.add(eventString);
                    }
                });
                EventSelectionPanel.this.send((IEventSink)EventSelectionPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, toBeAdded, toBeRemoved));
            }
        }});
        successGroup.setVisible(!events.isEmpty());
        this.add(new Component[]{successGroup});
        this.add(new Component[]{new Label("successLabel", (IModel)new ResourceModel("Success", "Success"))}).setVisible(!events.isEmpty());
        CheckGroupSelector successSelector = new CheckGroupSelector("successSelector", successGroup);
        successSelector.setVisible(!events.isEmpty());
        this.add(new Component[]{successSelector});
        ListView<String> categoryView = new ListView<String>("categoryView", events){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Label("subcategory", (IModel)Model.of((Serializable)((Object)((String)item.getModelObject()))))});
            }
        };
        this.add(new Component[]{categoryView});
        ListView<String> successView = new ListView<String>("successView", events){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("successCheck", (IModel)new Model((Serializable)((Object)AuditLoggerName.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)((String)item.getModelObject()), (AuditElements.Result)AuditElements.Result.SUCCESS))), successGroup)});
            }
        };
        successGroup.add(new Component[]{successView});
        final CheckGroup failureGroup = new CheckGroup("failureGroup", this.selected);
        failureGroup.add(new Behavior[]{new IndicatorAjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                HashSet<String> toBeRemoved = new HashSet<String>();
                HashSet<String> toBeAdded = new HashSet<String>();
                EventSelectionPanel.getEvents(eventCategoryTO).forEach(event -> {
                    String eventString = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)event, (AuditElements.Result)AuditElements.Result.FAILURE);
                    if (((Collection)failureGroup.getModelObject()).contains(eventString)) {
                        toBeAdded.add(eventString);
                    } else {
                        toBeRemoved.add(eventString);
                    }
                });
                EventSelectionPanel.this.send((IEventSink)EventSelectionPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, toBeAdded, toBeRemoved));
            }
        }});
        failureGroup.setVisible(!events.isEmpty());
        this.add(new Component[]{failureGroup});
        this.add(new Component[]{new Label("failureLabel", (IModel)new ResourceModel("Failure", "Failure"))}).setVisible(!events.isEmpty());
        CheckGroupSelector failureSelector = new CheckGroupSelector("failureSelector", failureGroup);
        failureSelector.setVisible(!events.isEmpty());
        this.add(new Component[]{failureSelector});
        ListView<String> failureView = new ListView<String>("failureView", events){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("failureCheck", (IModel)new Model((Serializable)((Object)AuditLoggerName.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)((String)item.getModelObject()), (AuditElements.Result)AuditElements.Result.FAILURE))), failureGroup)});
            }
        };
        failureGroup.add(new Component[]{failureView});
    }

    private static List<String> getEvents(EventCategory eventCategoryTO) {
        List res = eventCategoryTO.getEvents();
        if (res.isEmpty()) {
            if ((AuditElements.EventCategoryType.PROPAGATION == eventCategoryTO.getType() || AuditElements.EventCategoryType.PULL == eventCategoryTO.getType() || AuditElements.EventCategoryType.PUSH == eventCategoryTO.getType()) && StringUtils.isEmpty((CharSequence)eventCategoryTO.getCategory())) {
                res.add(eventCategoryTO.getType().toString());
            } else if (AuditElements.EventCategoryType.TASK == eventCategoryTO.getType() && StringUtils.isNotEmpty((CharSequence)eventCategoryTO.getCategory())) {
                res.add(eventCategoryTO.getCategory());
            }
        } else {
            Collections.sort(res);
        }
        return res;
    }

    protected abstract void onEventAction(IEvent<?> var1);

    public void onEvent(IEvent<?> event) {
        this.onEventAction(event);
    }
}

