/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.panels.UserSelfFormPanel;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SelfRegistration
extends BasePage {
    private static final long serialVersionUID = -1100228004207271270L;
    private static final String SELF_REGISTRATION = "page.selfRegistration";
    public static final String NEW_USER_PARAM = "newUser";
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();

    public SelfRegistration(PageParameters parameters) {
        super(parameters, SELF_REGISTRATION);
        this.setDomain(parameters);
        this.disableSidebar();
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.contentWrapper.add(new Component[]{content});
        UserSelfFormPanel selfRegistrationPanel = new UserSelfFormPanel("selfRegistrationPanel", SelfRegistration.buildNewUserTO(parameters), SelfRegistration.buildNewUserTO(parameters), SyncopeEnduserSession.get().getAnonymousClient().platform().getUserClasses(), this.buildFormLayout(), this.getPageReference());
        selfRegistrationPanel.setOutputMarkupId(true);
        content.add(new Component[]{selfRegistrationPanel});
    }

    private UserFormLayoutInfo buildFormLayout() {
        UserFormLayoutInfo customlayoutInfo = SyncopeWebApplication.get().getCustomFormLayout();
        return customlayoutInfo != null ? customlayoutInfo : new UserFormLayoutInfo();
    }

    private static UserTO buildNewUserTO(PageParameters parameters) {
        UserTO userTO = null;
        if (parameters != null && !parameters.get(NEW_USER_PARAM).isNull()) {
            try {
                userTO = (UserTO)MAPPER.readValue(parameters.get(NEW_USER_PARAM).toString(), UserTO.class);
            }
            catch (JsonProcessingException e) {
                LOG.error("While reading user data from social registration", (Throwable)e);
            }
        }
        if (userTO == null) {
            userTO = new UserTO();
        }
        userTO.setRealm("/");
        return userTO;
    }
}

