/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainAttrCheck;

public class JPAPlainAttrValidator
extends AbstractValidator<PlainAttrCheck, PlainAttr<?>> {
    public boolean isValid(PlainAttr<?> attr, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        if (attr == null) {
            isValid = true;
        } else {
            if (attr.getSchema().isUniqueConstraint()) {
                isValid = attr.getValues().isEmpty() && attr.getUniqueValue() != null;
            } else {
                boolean bl = isValid = !attr.getValues().isEmpty() && attr.getUniqueValue() == null;
                if (!attr.getSchema().isMultivalue()) {
                    isValid &= attr.getValues().size() == 1;
                }
            }
            if (!isValid) {
                LOG.error("Invalid values for attribute schema={}, values={}", (Object)attr.getSchema().getKey(), (Object)attr.getValuesAsStrings());
                context.buildConstraintViolationWithTemplate(JPAPlainAttrValidator.getTemplate(EntityViolationType.InvalidValueList, "Invalid values " + attr.getValuesAsStrings())).addPropertyNode(attr.getSchema().getKey()).addConstraintViolation();
            }
        }
        return isValid;
    }
}

