/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;

public class JPAAnyUtilsFactory
implements AnyUtilsFactory {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final EntityFactory entityFactory;
    protected final Map<AnyTypeKind, AnyUtils> instances = new HashMap<AnyTypeKind, AnyUtils>(3);
    protected AnyUtils linkedAccountInstance;

    public JPAAnyUtilsFactory(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, EntityFactory entityFactory) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.entityFactory = entityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnyUtils getInstance(AnyTypeKind anyTypeKind) {
        AnyUtils instance;
        Map<AnyTypeKind, AnyUtils> map = this.instances;
        synchronized (map) {
            instance = this.instances.get(anyTypeKind);
            if (instance == null) {
                instance = new JPAAnyUtils(this.userDAO, this.groupDAO, this.anyObjectDAO, this.entityFactory, anyTypeKind, false);
                ApplicationContextProvider.getBeanFactory().autowireBean((Object)instance);
                this.instances.put(anyTypeKind, instance);
            }
        }
        return instance;
    }

    public AnyUtils getInstance(Any<?> any) {
        AnyTypeKind type = null;
        if (any instanceof User) {
            type = AnyTypeKind.USER;
        } else if (any instanceof Group) {
            type = AnyTypeKind.GROUP;
        } else if (any instanceof AnyObject) {
            type = AnyTypeKind.ANY_OBJECT;
        }
        if (type == null) {
            throw new IllegalArgumentException("Any type not supported: " + any.getClass().getName());
        }
        return this.getInstance(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnyUtils getLinkedAccountInstance() {
        JPAAnyUtilsFactory jPAAnyUtilsFactory = this;
        synchronized (jPAAnyUtilsFactory) {
            if (this.linkedAccountInstance == null) {
                this.linkedAccountInstance = new JPAAnyUtils(this.userDAO, this.groupDAO, this.anyObjectDAO, this.entityFactory, AnyTypeKind.USER, true);
            }
        }
        return this.linkedAccountInstance;
    }
}

