/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.syncope.common.lib.policy.DefaultPushCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.search.ConnObjectTOFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PushCorrelationRuleConfClass(value=DefaultPushCorrelationRuleConf.class)
public class DefaultPushCorrelationRule
implements PushCorrelationRule {
    protected static final ConnObjectTOFiqlSearchConditionBuilder FIQL_BUILDER = new ConnObjectTOFiqlSearchConditionBuilder();
    @Autowired
    protected MappingManager mappingManager;
    protected DefaultPushCorrelationRuleConf conf;

    public void setConf(PushCorrelationRuleConf conf) {
        if (!(conf instanceof DefaultPushCorrelationRuleConf)) {
            throw new IllegalArgumentException(DefaultPushCorrelationRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultPushCorrelationRuleConf)DefaultPushCorrelationRuleConf.class.cast(conf);
    }

    public Filter getFilter(Any<?> any, ExternalResource resource, Provision provision) {
        ArrayList filters = new ArrayList();
        provision.getMapping().getItems().stream().filter(item -> this.conf.getSchemas().contains(item.getIntAttrName()) && item.getPurpose() != MappingPurpose.NONE).forEach(item -> {
            Pair attr = this.mappingManager.prepareAttr(resource, provision, item, any, null, AccountGetter.DEFAULT, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT);
            if (attr != null) {
                Attribute toFilter = null;
                if (attr.getLeft() != null) {
                    toFilter = AttributeBuilder.build((String)item.getExtAttrName(), (Object[])new Object[]{attr.getLeft()});
                } else if (attr.getRight() != null) {
                    toFilter = (Attribute)attr.getRight();
                }
                if (toFilter != null) {
                    filters.add(provision.isIgnoreCaseMatch() ? FilterBuilder.equalsIgnoreCase((Attribute)toFilter) : FilterBuilder.equalTo((Attribute)toFilter));
                }
            }
        });
        return this.conf.isOrSchemas() ? FilterBuilder.or(filters) : FilterBuilder.and(filters);
    }

    public String getFIQL(ConnectorObject connectorObject, Provision provision) {
        ArrayList conditions = new ArrayList();
        provision.getMapping().getItems().stream().filter(item -> this.conf.getSchemas().contains(item.getIntAttrName()) && item.getPurpose() != MappingPurpose.NONE).forEach(item -> Optional.ofNullable(connectorObject.getAttributeByName(item.getExtAttrName())).ifPresent(attr -> {
            if (CollectionUtils.isEmpty((Collection)attr.getValue())) {
                conditions.add(FIQL_BUILDER.isNull(attr.getName()));
            } else {
                ArrayList valueConditions = new ArrayList();
                attr.getValue().stream().filter(Objects::nonNull).forEach(value -> {
                    if (value instanceof GuardedString) {
                        valueConditions.add(FIQL_BUILDER.is(attr.getName()).equalTo(SecurityUtil.decrypt((GuardedString)((GuardedString)value)), new String[0]));
                    } else if (value instanceof GuardedByteArray) {
                        valueConditions.add(FIQL_BUILDER.is(attr.getName()).equalTo(new String(SecurityUtil.decrypt((GuardedByteArray)((GuardedByteArray)value))), new String[0]));
                    } else if (value instanceof byte[]) {
                        valueConditions.add(FIQL_BUILDER.is(attr.getName()).equalTo(Base64.getEncoder().encodeToString((byte[])value), new String[0]));
                    } else {
                        valueConditions.add(FIQL_BUILDER.is(attr.getName()).equalTo(value.toString(), new String[0]));
                    }
                });
                if (!valueConditions.isEmpty()) {
                    conditions.add(valueConditions.size() == 1 ? (CompleteCondition)valueConditions.get(0) : FIQL_BUILDER.and(valueConditions));
                }
            }
        }));
        return this.conf.isOrSchemas() ? FIQL_BUILDER.or(conditions).query() : FIQL_BUILDER.and(conditions).query();
    }
}

