/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.jpa.spring.DomainEntityManagerFactoryBean;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.vendor.OpenJpaVendorAdapter;

public class DomainConfFactory
implements DomainRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainConfFactory.class);
    protected final Environment env;

    protected static void unregisterSingleton(String name) {
        if (ApplicationContextProvider.getBeanFactory().containsSingleton(name)) {
            ApplicationContextProvider.getBeanFactory().destroySingleton(name);
        }
    }

    protected static void registerSingleton(String name, Object bean) {
        DomainConfFactory.unregisterSingleton(name);
        ApplicationContextProvider.getBeanFactory().registerSingleton(name, bean);
    }

    protected static void unregisterBeanDefinition(String name) {
        if (ApplicationContextProvider.getBeanFactory().containsBeanDefinition(name)) {
            ApplicationContextProvider.getBeanFactory().removeBeanDefinition(name);
        }
    }

    protected static void registerBeanDefinition(String name, BeanDefinition beanDefinition) {
        DomainConfFactory.unregisterBeanDefinition(name);
        ApplicationContextProvider.getBeanFactory().registerBeanDefinition(name, beanDefinition);
    }

    public DomainConfFactory(Environment env) {
        this.env = env;
    }

    public void register(Domain domain) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(domain.getJdbcDriver());
        hikariConfig.setJdbcUrl(domain.getJdbcURL());
        hikariConfig.setUsername(domain.getDbUsername());
        hikariConfig.setPassword(domain.getDbPassword());
        hikariConfig.setSchema(domain.getDbSchema());
        hikariConfig.setTransactionIsolation(domain.getTransactionIsolation().name());
        hikariConfig.setMaximumPoolSize(domain.getPoolMaxActive());
        hikariConfig.setMinimumIdle(domain.getPoolMinIdle());
        DomainConfFactory.registerBeanDefinition(domain.getKey() + "DataSource", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(JndiObjectFactoryBean.class).addPropertyValue("jndiName", (Object)("java:comp/env/jdbc/syncope" + domain.getKey() + "DataSource")).addPropertyValue("defaultObject", (Object)new HikariDataSource(hikariConfig)).getBeanDefinition());
        DataSource initedDataSource = (DataSource)ApplicationContextProvider.getBeanFactory().getBean(domain.getKey() + "DataSource", DataSource.class);
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
        databasePopulator.setContinueOnError(true);
        databasePopulator.setIgnoreFailedDrops(true);
        databasePopulator.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        databasePopulator.addScript((Resource)new ClassPathResource("/audit/" + domain.getAuditSql()));
        DomainConfFactory.registerSingleton(domain.getKey().toLowerCase() + "ResourceDatabasePopulator", databasePopulator);
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(initedDataSource);
        dataSourceInitializer.setEnabled(true);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)databasePopulator);
        DomainConfFactory.registerSingleton(domain.getKey().toLowerCase() + "DataSourceInitializer", dataSourceInitializer);
        OpenJpaVendorAdapter vendorAdapter = new OpenJpaVendorAdapter();
        vendorAdapter.setShowSql(false);
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setDatabasePlatform(domain.getDatabasePlatform());
        BeanDefinitionBuilder emf = BeanDefinitionBuilder.rootBeanDefinition(DomainEntityManagerFactoryBean.class).addPropertyValue("mappingResources", (Object)domain.getOrm()).addPropertyValue("persistenceUnitName", (Object)domain.getKey()).addPropertyReference("dataSource", domain.getKey() + "DataSource").addPropertyValue("jpaVendorAdapter", (Object)vendorAdapter).addPropertyReference("commonEntityManagerFactoryConf", "commonEMFConf");
        if (this.env.containsProperty("openjpaMetaDataFactory")) {
            emf.addPropertyValue("jpaPropertyMap", Map.of("openjpa.MetaDataFactory", Objects.requireNonNull(this.env.getProperty("openjpaMetaDataFactory")).replace("##orm##", domain.getOrm())));
        }
        DomainConfFactory.registerBeanDefinition(domain.getKey() + "EntityManagerFactory", (BeanDefinition)emf.getBeanDefinition());
        ApplicationContextProvider.getBeanFactory().getBean(domain.getKey() + "EntityManagerFactory");
        AbstractBeanDefinition domainTransactionManager = BeanDefinitionBuilder.rootBeanDefinition(JpaTransactionManager.class).addPropertyReference("entityManagerFactory", domain.getKey() + "EntityManagerFactory").getBeanDefinition();
        domainTransactionManager.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)domain.getKey()));
        DomainConfFactory.registerBeanDefinition(domain.getKey() + "TransactionManager", (BeanDefinition)domainTransactionManager);
        DomainConfFactory.registerBeanDefinition(domain.getKey() + "ContentXML", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ByteArrayInputStream.class).addConstructorArgValue((Object)domain.getContent().getBytes()).getBeanDefinition());
        DomainConfFactory.registerBeanDefinition(domain.getKey() + "KeymasterConfParamsJSON", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ByteArrayInputStream.class).addConstructorArgValue((Object)domain.getKeymasterConfParams().getBytes()).getBeanDefinition());
    }

    public void unregister(String domain) {
        DomainConfFactory.unregisterSingleton(domain + "KeymasterConfParamsJSON");
        DomainConfFactory.unregisterBeanDefinition(domain + "KeymasterConfParamsJSON");
        DomainConfFactory.unregisterSingleton(domain + "ContentXML");
        DomainConfFactory.unregisterBeanDefinition(domain + "ContentXML");
        try {
            EntityManagerFactory emf = (EntityManagerFactory)ApplicationContextProvider.getBeanFactory().getBean(domain + "EntityManagerFactory", EntityManagerFactory.class);
            emf.close();
        }
        catch (Exception e) {
            LOG.error("Could not close EntityManagerFactory for Domain {}", (Object)domain, (Object)e);
        }
        DomainConfFactory.unregisterSingleton(domain + "EntityManagerFactory");
        DomainConfFactory.unregisterBeanDefinition(domain + "EntityManagerFactory");
        DomainConfFactory.unregisterSingleton(domain + "TransactionManager");
        DomainConfFactory.unregisterBeanDefinition(domain + "TransactionManager");
        DomainConfFactory.unregisterSingleton(domain.toLowerCase() + "DataSourceInitializer");
        DomainConfFactory.unregisterSingleton(domain.toLowerCase() + "ResourceDatabasePopulator");
        DomainConfFactory.unregisterSingleton(domain + "DataSource");
        DomainConfFactory.unregisterBeanDefinition(domain + "DataSource");
    }
}

