/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.factory;

import java.util.HashMap;
import java.util.Map;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.engine.delegate.CustomPropertiesResolver;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.TransactionDependentTaskListener;
import org.flowable.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.flowable.engine.impl.bpmn.helper.ClassDelegateFactory;
import org.flowable.engine.impl.bpmn.helper.DefaultClassDelegateFactory;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionFlowableEventListener;
import org.flowable.engine.impl.bpmn.helper.DelegateFlowableEventListener;
import org.flowable.engine.impl.bpmn.helper.ErrorThrowingEventListener;
import org.flowable.engine.impl.bpmn.helper.MessageThrowingEventListener;
import org.flowable.engine.impl.bpmn.helper.SignalThrowingEventListener;
import org.flowable.engine.impl.bpmn.listener.DelegateExpressionCustomPropertiesResolver;
import org.flowable.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.flowable.engine.impl.bpmn.listener.DelegateExpressionTaskListener;
import org.flowable.engine.impl.bpmn.listener.DelegateExpressionTransactionDependentExecutionListener;
import org.flowable.engine.impl.bpmn.listener.DelegateExpressionTransactionDependentTaskListener;
import org.flowable.engine.impl.bpmn.listener.ExpressionCustomPropertiesResolver;
import org.flowable.engine.impl.bpmn.listener.ExpressionExecutionListener;
import org.flowable.engine.impl.bpmn.listener.ExpressionTaskListener;
import org.flowable.engine.impl.bpmn.parser.factory.AbstractBehaviorFactory;
import org.flowable.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.Attachment;
import org.flowable.engine.task.Comment;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.job.api.Job;
import org.flowable.task.api.Task;
import org.flowable.task.service.delegate.TaskListener;

public class DefaultListenerFactory
extends AbstractBehaviorFactory
implements ListenerFactory {
    private final ClassDelegateFactory classDelegateFactory;
    public static final Map<String, Class<?>> ENTITY_MAPPING = new HashMap();

    public DefaultListenerFactory(ClassDelegateFactory classDelegateFactory) {
        this.classDelegateFactory = classDelegateFactory;
    }

    public DefaultListenerFactory() {
        this(new DefaultClassDelegateFactory());
    }

    @Override
    public TaskListener createClassDelegateTaskListener(FlowableListener listener) {
        return this.classDelegateFactory.create(listener.getImplementation(), this.createFieldDeclarations(listener.getFieldExtensions()));
    }

    @Override
    public TaskListener createExpressionTaskListener(FlowableListener listener) {
        return new ExpressionTaskListener(this.expressionManager.createExpression(listener.getImplementation()));
    }

    @Override
    public TaskListener createDelegateExpressionTaskListener(FlowableListener listener) {
        return new DelegateExpressionTaskListener(this.expressionManager.createExpression(listener.getImplementation()), this.createFieldDeclarations(listener.getFieldExtensions()));
    }

    @Override
    public TransactionDependentTaskListener createTransactionDependentDelegateExpressionTaskListener(FlowableListener listener) {
        return new DelegateExpressionTransactionDependentTaskListener(this.expressionManager.createExpression(listener.getImplementation()));
    }

    @Override
    public ExecutionListener createClassDelegateExecutionListener(FlowableListener listener) {
        return this.classDelegateFactory.create(listener.getImplementation(), this.createFieldDeclarations(listener.getFieldExtensions()));
    }

    @Override
    public ExecutionListener createExpressionExecutionListener(FlowableListener listener) {
        return new ExpressionExecutionListener(this.expressionManager.createExpression(listener.getImplementation()));
    }

    @Override
    public ExecutionListener createDelegateExpressionExecutionListener(FlowableListener listener) {
        return new DelegateExpressionExecutionListener(this.expressionManager.createExpression(listener.getImplementation()), this.createFieldDeclarations(listener.getFieldExtensions()));
    }

    @Override
    public DelegateExpressionTransactionDependentExecutionListener createTransactionDependentDelegateExpressionExecutionListener(FlowableListener listener) {
        return new DelegateExpressionTransactionDependentExecutionListener(this.expressionManager.createExpression(listener.getImplementation()));
    }

    @Override
    public FlowableEventListener createClassDelegateEventListener(EventListener eventListener) {
        return new DelegateFlowableEventListener(eventListener.getImplementation(), this.getEntityType(eventListener.getEntityType()));
    }

    @Override
    public FlowableEventListener createDelegateExpressionEventListener(EventListener eventListener) {
        return new DelegateExpressionFlowableEventListener(this.expressionManager.createExpression(eventListener.getImplementation()), this.getEntityType(eventListener.getEntityType()));
    }

    @Override
    public FlowableEventListener createEventThrowingEventListener(EventListener eventListener) {
        BaseDelegateEventListener result = null;
        if ("throwSignalEvent".equals(eventListener.getImplementationType())) {
            result = new SignalThrowingEventListener();
            ((SignalThrowingEventListener)result).setSignalName(eventListener.getImplementation());
            ((SignalThrowingEventListener)result).setProcessInstanceScope(true);
        } else if ("throwGlobalSignalEvent".equals(eventListener.getImplementationType())) {
            result = new SignalThrowingEventListener();
            ((SignalThrowingEventListener)result).setSignalName(eventListener.getImplementation());
            ((SignalThrowingEventListener)result).setProcessInstanceScope(false);
        } else if ("throwMessageEvent".equals(eventListener.getImplementationType())) {
            result = new MessageThrowingEventListener();
            ((MessageThrowingEventListener)result).setMessageName(eventListener.getImplementation());
        } else if ("throwErrorEvent".equals(eventListener.getImplementationType())) {
            result = new ErrorThrowingEventListener();
            ((ErrorThrowingEventListener)result).setErrorCode(eventListener.getImplementation());
        }
        if (result == null) {
            throw new FlowableIllegalArgumentException("Cannot create an event-throwing event-listener, unknown implementation type: " + eventListener.getImplementationType());
        }
        result.setEntityClass(this.getEntityType(eventListener.getEntityType()));
        return result;
    }

    @Override
    public CustomPropertiesResolver createClassDelegateCustomPropertiesResolver(FlowableListener listener) {
        return this.classDelegateFactory.create(listener.getCustomPropertiesResolverImplementation(), null);
    }

    @Override
    public CustomPropertiesResolver createExpressionCustomPropertiesResolver(FlowableListener listener) {
        return new ExpressionCustomPropertiesResolver(this.expressionManager.createExpression(listener.getCustomPropertiesResolverImplementation()));
    }

    @Override
    public CustomPropertiesResolver createDelegateExpressionCustomPropertiesResolver(FlowableListener listener) {
        return new DelegateExpressionCustomPropertiesResolver(this.expressionManager.createExpression(listener.getCustomPropertiesResolverImplementation()));
    }

    protected Class<?> getEntityType(String entityType) {
        if (entityType != null) {
            Class<?> entityClass = ENTITY_MAPPING.get(entityType.trim());
            if (entityClass == null) {
                throw new FlowableIllegalArgumentException("Unsupported entity-type for a FlowableEventListener: " + entityType);
            }
            return entityClass;
        }
        return null;
    }

    static {
        ENTITY_MAPPING.put("attachment", Attachment.class);
        ENTITY_MAPPING.put("comment", Comment.class);
        ENTITY_MAPPING.put("execution", Execution.class);
        ENTITY_MAPPING.put("identity-link", IdentityLink.class);
        ENTITY_MAPPING.put("job", Job.class);
        ENTITY_MAPPING.put("process-definition", ProcessDefinition.class);
        ENTITY_MAPPING.put("process-instance", ProcessInstance.class);
        ENTITY_MAPPING.put("task", Task.class);
    }
}

