/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.oidc;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.oidc.NoOpLogoutHandler;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientCache {
    protected static final Logger LOG = LoggerFactory.getLogger(OIDCClientCache.class);
    protected final List<OidcClient> cache = Collections.synchronizedList(new ArrayList());

    protected static OIDCProviderMetadata getDiscoveryDocument(String issuer) {
        String discoveryDocumentURL = issuer + "/.well-known/openid-configuration";
        try {
            HttpResponse<String> response = HttpClient.newBuilder().build().send(HttpRequest.newBuilder(URI.create(discoveryDocumentURL)).GET().build(), HttpResponse.BodyHandlers.ofString());
            return OIDCProviderMetadata.parse((String)response.body());
        }
        catch (ParseException | IOException | InterruptedException e) {
            LOG.error("While getting the Discovery Document at {}", (Object)discoveryDocumentURL, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    public static void importMetadata(OIDCC4UIProviderTO opTO) {
        OIDCProviderMetadata metadata = OIDCClientCache.getDiscoveryDocument(opTO.getIssuer());
        opTO.setIssuer((String)Optional.ofNullable(metadata.getIssuer()).map(Identifier::getValue).orElse(null));
        opTO.setJwksUri((String)Optional.ofNullable(metadata.getJWKSetURI()).map(URI::toASCIIString).orElse(null));
        opTO.setAuthorizationEndpoint((String)Optional.ofNullable(metadata.getAuthorizationEndpointURI()).map(URI::toASCIIString).orElse(null));
        opTO.setTokenEndpoint((String)Optional.ofNullable(metadata.getTokenEndpointURI()).map(URI::toASCIIString).orElse(null));
        opTO.setUserinfoEndpoint((String)Optional.ofNullable(metadata.getUserInfoEndpointURI()).map(URI::toASCIIString).orElse(null));
        opTO.setEndSessionEndpoint((String)Optional.ofNullable(metadata.getEndSessionEndpointURI()).map(URI::toASCIIString).orElse(null));
    }

    public Optional<OidcClient> get(String opName) {
        return this.cache.stream().filter(c -> opName.equals(c.getName())).findFirst();
    }

    public OidcClient add(OIDCC4UIProvider op, String callbackUrl) {
        OIDCProviderMetadata metadata = new OIDCProviderMetadata(new Issuer(op.getIssuer()), List.of(SubjectType.PUBLIC), (URI)Optional.ofNullable(op.getJwksUri()).map(URI::create).orElse(null));
        metadata.setAuthorizationEndpointURI((URI)Optional.ofNullable(op.getAuthorizationEndpoint()).map(URI::create).orElse(null));
        metadata.setTokenEndpointURI((URI)Optional.ofNullable(op.getTokenEndpoint()).map(URI::create).orElse(null));
        metadata.setUserInfoEndpointURI((URI)Optional.ofNullable(op.getUserinfoEndpoint()).map(URI::create).orElse(null));
        metadata.setEndSessionEndpointURI((URI)Optional.ofNullable(op.getEndSessionEndpoint()).map(URI::create).orElse(null));
        OidcConfiguration config = new OidcConfiguration();
        config.setClientId(op.getClientID());
        config.setSecret(op.getClientSecret());
        config.setProviderMetadata(metadata);
        config.setScope("openid profile email address phone offline_access");
        config.setUseNonce(false);
        config.setLogoutHandler((LogoutHandler)new NoOpLogoutHandler());
        OidcClient client = new OidcClient(config);
        client.setName(op.getName());
        client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        client.setCallbackUrl(callbackUrl);
        client.init();
        return client;
    }

    public boolean removeAll(String opName) {
        return this.cache.removeIf(c -> opName.equals(c.getName()));
    }
}

