/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.internal;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.core.logic.ConfParamLogic;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfKeymasterInternalConfParamOps
implements ConfParamOps {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfParamOps.class);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ConfParamLogic logic;
    protected final KeymasterProperties props;

    public SelfKeymasterInternalConfParamOps(ConfParamLogic logic, KeymasterProperties props) {
        this.logic = logic;
        this.props = props;
    }

    public Map<String, Object> list(String domain) {
        return (Map)AuthContextUtils.callAs((String)domain, (String)this.props.getUsername(), List.of(), () -> this.logic.list());
    }

    public <T> T get(String domain, String key, T defaultValue, Class<T> reference) {
        JsonNode valueNode = (JsonNode)AuthContextUtils.callAs((String)domain, (String)this.props.getUsername(), List.of(), () -> this.logic.get(key));
        if (valueNode == null) {
            return defaultValue;
        }
        try {
            return (T)MAPPER.treeToValue((TreeNode)valueNode, reference);
        }
        catch (IOException e) {
            LOG.error("Could not deserialize {}", (Object)valueNode, (Object)e);
            return defaultValue;
        }
    }

    public <T> void set(String domain, String key, T value) {
        if (value == null) {
            this.remove(domain, key);
        } else {
            JsonNode valueNode = MAPPER.valueToTree(value);
            AuthContextUtils.callAs((String)domain, (String)this.props.getUsername(), List.of(), () -> {
                this.logic.set(key, valueNode);
                return null;
            });
        }
    }

    public void remove(String domain, String key) {
        AuthContextUtils.callAs((String)domain, (String)this.props.getUsername(), List.of(), () -> {
            this.logic.remove(key);
            return null;
        });
    }
}

