/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.saml2.SAML2LoginResponse;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SP4UIIdPDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIIdP;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.SAML2SP4UIIdPActions;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class SAML2SP4UIUserManager {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2SP4UIUserManager.class);
    private static final String SAML2SP_CONTEXT = "SAML 2.0 SP";
    protected final SAML2SP4UIIdPDAO idpDAO;
    protected final InboundMatcher inboundMatcher;
    protected final UserDAO userDAO;
    protected final ImplementationDAO implementationDAO;
    protected final IntAttrNameParser intAttrNameParser;
    protected final TemplateUtils templateUtils;
    protected final UserProvisioningManager provisioningManager;
    protected final UserDataBinder binder;
    protected final Map<String, SAML2SP4UIIdPActions> perContextActions = new ConcurrentHashMap<String, SAML2SP4UIIdPActions>();

    public SAML2SP4UIUserManager(SAML2SP4UIIdPDAO idpDAO, InboundMatcher inboundMatcher, UserDAO userDAO, ImplementationDAO implementationDAO, IntAttrNameParser intAttrNameParser, TemplateUtils templateUtils, UserProvisioningManager provisioningManager, UserDataBinder binder) {
        this.idpDAO = idpDAO;
        this.inboundMatcher = inboundMatcher;
        this.userDAO = userDAO;
        this.implementationDAO = implementationDAO;
        this.intAttrNameParser = intAttrNameParser;
        this.templateUtils = templateUtils;
        this.provisioningManager = provisioningManager;
        this.binder = binder;
    }

    @Transactional(readOnly=true)
    public List<String> findMatchingUser(String connObjectKeyValue, String idpKey) {
        SAML2SP4UIIdP idp = this.idpDAO.find(idpKey);
        if (idp == null) {
            LOG.warn("Invalid IdP: {}", (Object)idpKey);
            return List.of();
        }
        if (idp.getConnObjectKeyItem().isEmpty()) {
            LOG.warn("Unable to determine conn object key item for  IdP: {}", (Object)idpKey);
            return Collections.emptyList();
        }
        return this.inboundMatcher.matchByConnObjectKeyValue((Item)idp.getConnObjectKeyItem().get(), connObjectKeyValue, AnyTypeKind.USER, false, null).stream().filter(match -> match.getAny() != null).map(match -> ((User)match.getAny()).getUsername()).collect(Collectors.toList());
    }

    protected List<SAML2SP4UIIdPActions> getActions(SAML2SP4UIIdP idp) {
        ArrayList<SAML2SP4UIIdPActions> result = new ArrayList<SAML2SP4UIIdPActions>();
        idp.getActions().forEach(impl -> {
            try {
                result.add((SAML2SP4UIIdPActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (SAML2SP4UIIdPActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected List<Implementation> getTransformers(Item item) {
        return item.getTransformers().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void fill(String idpKey, SAML2LoginResponse loginResponse, UserTO userTO) {
        SAML2SP4UIIdP idp = this.idpDAO.find(idpKey);
        if (idp == null) {
            LOG.warn("Invalid IdP: {}", (Object)idpKey);
            return;
        }
        idp.getItems().forEach(item -> {
            block19: {
                IntAttrName intAttrName;
                List values;
                block18: {
                    values = List.of();
                    Optional samlAttr = loginResponse.getAttr(item.getExtAttrName());
                    if (samlAttr.isPresent() && !((Attr)samlAttr.get()).getValues().isEmpty()) {
                        values = ((Attr)samlAttr.get()).getValues();
                        List transformed = new ArrayList(values);
                        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)item, this.getTransformers((Item)item))) {
                            transformed = transformer.beforePull(null, (EntityTO)userTO, transformed);
                        }
                        values.clear();
                        for (Object value : transformed) {
                            values.add(value.toString());
                        }
                    }
                    intAttrName = null;
                    try {
                        intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), AnyTypeKind.USER);
                    }
                    catch (ParseException e) {
                        LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
                    }
                    if (intAttrName == null || intAttrName.getField() == null) break block18;
                    switch (intAttrName.getField()) {
                        case "username": {
                            if (!values.isEmpty()) {
                                userTO.setUsername((String)values.get(0));
                                break;
                            }
                            break block19;
                        }
                        default: {
                            LOG.warn("Unsupported: {}", (Object)intAttrName.getField());
                            break;
                        }
                    }
                    break block19;
                }
                if (intAttrName != null && intAttrName.getSchemaType() != null) {
                    switch (intAttrName.getSchemaType()) {
                        case PLAIN: {
                            Optional<Attr> attr = userTO.getPlainAttr(intAttrName.getSchema().getKey());
                            if (attr.isPresent()) {
                                ((Attr)attr.get()).getValues().clear();
                            } else {
                                attr = Optional.of(new Attr.Builder(intAttrName.getSchema().getKey()).build());
                                userTO.getPlainAttrs().add(attr.get());
                            }
                            ((Attr)attr.get()).getValues().addAll(values);
                            break;
                        }
                        default: {
                            LOG.warn("Unsupported: {} {}", (Object)intAttrName.getSchemaType(), (Object)intAttrName.getSchema().getKey());
                        }
                    }
                }
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String create(SAML2SP4UIIdP idp, SAML2LoginResponse loginResponse, String nameID) {
        UserCR userCR = new UserCR();
        userCR.setStorePassword(false);
        if (idp.getUserTemplate() != null) {
            this.templateUtils.apply((RealmMember)userCR, idp.getUserTemplate().get());
        }
        List<SAML2SP4UIIdPActions> actions = this.getActions(idp);
        for (SAML2SP4UIIdPActions action : actions) {
            userCR = action.beforeCreate(userCR, loginResponse);
        }
        UserTO userTO = new UserTO();
        this.fill(idp.getKey(), loginResponse, userTO);
        EntityTOUtils.toAnyCR((AnyTO)userTO, (AnyCR)userCR);
        if (userCR.getRealm() == null) {
            userCR.setRealm("/");
        }
        if (userCR.getUsername() == null) {
            userCR.setUsername(nameID);
        }
        Pair created = this.provisioningManager.create((AnyCR)userCR, false, userCR.getUsername(), SAML2SP_CONTEXT);
        userTO = this.binder.getUserTO((String)created.getKey());
        for (SAML2SP4UIIdPActions action : actions) {
            userTO = action.afterCreate(userTO, loginResponse);
        }
        return userTO.getUsername();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String update(String username, SAML2SP4UIIdP idp, SAML2LoginResponse loginResponse) {
        UserTO userTO = this.binder.getUserTO(this.userDAO.findKey(username));
        UserTO original = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.fill(idp.getKey(), loginResponse, userTO);
        UserUR userUR = AnyOperations.diff((UserTO)userTO, (UserTO)original, (boolean)true);
        List<SAML2SP4UIIdPActions> actions = this.getActions(idp);
        for (SAML2SP4UIIdPActions action : actions) {
            userUR = action.beforeUpdate(userUR, loginResponse);
        }
        Pair updated = this.provisioningManager.update(userUR, false, userTO.getUsername(), SAML2SP_CONTEXT);
        userTO = this.binder.getUserTO(((UserUR)updated.getLeft()).getKey());
        for (SAML2SP4UIIdPActions action : actions) {
            userTO = action.afterUpdate(userTO, loginResponse);
        }
        return userTO.getUsername();
    }
}

