/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SAML2SP4UIIdPTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.init.SAML2SP4UILoader;
import org.apache.syncope.core.logic.saml2.SAML2ClientCache;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2SP4UIIdPDAO;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIIdP;
import org.apache.syncope.core.provisioning.api.data.SAML2SP4UIIdPDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SAML2SP4UIIdPLogic
extends AbstractTransactionalLogic<SAML2SP4UIIdPTO> {
    protected final SAML2SP4UILoader loader;
    protected final SAML2ClientCache saml2ClientCache;
    protected final SAML2SP4UIIdPDataBinder binder;
    protected final SAML2SP4UIIdPDAO idpDAO;

    public SAML2SP4UIIdPLogic(SAML2SP4UILoader loader, SAML2ClientCache saml2ClientCache, SAML2SP4UIIdPDataBinder binder, SAML2SP4UIIdPDAO idpDAO) {
        this.loader = loader;
        this.saml2ClientCache = saml2ClientCache;
        this.binder = binder;
        this.idpDAO = idpDAO;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<SAML2SP4UIIdPTO> list() {
        return this.idpDAO.findAll().stream().map(arg_0 -> ((SAML2SP4UIIdPDataBinder)this.binder).getIdPTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('IDP_READ')")
    @Transactional(readOnly=true)
    public SAML2SP4UIIdPTO read(String key) {
        SAML2SP4UIIdP idp = this.idpDAO.find(key);
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + key + "'");
        }
        return this.binder.getIdPTO(idp);
    }

    @PreAuthorize(value="hasRole('IDP_IMPORT')")
    public String importFromMetadata(InputStream input) {
        try {
            SAML2SP4UIIdPTO idpTO = SAML2ClientCache.importMetadata(input, this.loader.newSAML2Configuration());
            SAML2SP4UIIdP idp = this.binder.create(idpTO);
            return idp.getKey();
        }
        catch (SyncopeClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Unexpected error while importing IdP metadata", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public void update(SAML2SP4UIIdPTO saml2IdpTO) {
        SAML2SP4UIIdP idp = this.idpDAO.find(saml2IdpTO.getKey());
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + saml2IdpTO.getKey() + "'");
        }
        idp = this.binder.update(idp, saml2IdpTO);
        this.saml2ClientCache.removeAll(idp.getEntityID());
    }

    @PreAuthorize(value="hasRole('IDP_DELETE')")
    public void delete(String key) {
        SAML2SP4UIIdP idp = this.idpDAO.find(key);
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + key + "'");
        }
        this.idpDAO.delete(key);
        this.saml2ClientCache.removeAll(idp.getEntityID());
    }

    protected SAML2SP4UIIdPTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SAML2SP4UIIdPTO)) continue;
                key = ((SAML2SP4UIIdPTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                SAML2SP4UIIdP idp = this.idpDAO.find(key);
                return this.binder.getIdPTO(idp);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

