/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.to.TypeExtensionTO;

@JsonPropertyOrder(value={"_class", "name"})
@Schema(allOf={AnyCR.class})
public class GroupCR
extends AnyCR {
    private static final long serialVersionUID = -4559772531167385473L;
    private String name;
    private String userOwner;
    private String groupOwner;
    private String udynMembershipCond;
    private final Map<String, String> adynMembershipConds = new HashMap<String, String>();
    private final List<TypeExtensionTO> typeExtensions = new ArrayList<TypeExtensionTO>();

    @Override
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    @Schema(name="_class", required=true, example="org.apache.syncope.common.lib.request.GroupCR")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @JsonProperty(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserOwner() {
        return this.userOwner;
    }

    public void setUserOwner(String userOwner) {
        this.userOwner = userOwner;
    }

    public String getGroupOwner() {
        return this.groupOwner;
    }

    public void setGroupOwner(String groupOwner) {
        this.groupOwner = groupOwner;
    }

    public String getUDynMembershipCond() {
        return this.udynMembershipCond;
    }

    public void setUDynMembershipCond(String uDynMembershipCond) {
        this.udynMembershipCond = uDynMembershipCond;
    }

    public Map<String, String> getADynMembershipConds() {
        return this.adynMembershipConds;
    }

    @JacksonXmlElementWrapper(localName="typeExtensions")
    @JacksonXmlProperty(localName="typeExtension")
    public List<TypeExtensionTO> getTypeExtensions() {
        return this.typeExtensions;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.name).append((Object)this.userOwner).append((Object)this.groupOwner).append((Object)this.udynMembershipCond).append(this.adynMembershipConds).append(this.typeExtensions).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupCR other = (GroupCR)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.name, (Object)other.name).append((Object)this.userOwner, (Object)other.userOwner).append((Object)this.groupOwner, (Object)other.groupOwner).append((Object)this.udynMembershipCond, (Object)other.udynMembershipCond).append(this.adynMembershipConds, other.adynMembershipConds).append(this.typeExtensions, other.typeExtensions).build();
    }

    public static class Builder
    extends AnyCR.Builder<GroupCR, Builder> {
        public Builder(String realm, String name) {
            super(realm);
            ((GroupCR)this.getInstance()).setName(name);
        }

        @Override
        protected GroupCR newInstance() {
            return new GroupCR();
        }

        public Builder userOwner(String userOwner) {
            ((GroupCR)this.getInstance()).setUserOwner(userOwner);
            return this;
        }

        public Builder groupOwner(String groupOwner) {
            ((GroupCR)this.getInstance()).setGroupOwner(groupOwner);
            return this;
        }

        public Builder udynMembershipCond(String udynMembershipCond) {
            ((GroupCR)this.getInstance()).setUDynMembershipCond(udynMembershipCond);
            return this;
        }

        public Builder adynMembershipCond(String type, String fiql) {
            ((GroupCR)this.getInstance()).getADynMembershipConds().put(type, fiql);
            return this;
        }

        public Builder typeExtension(TypeExtensionTO typeExtension) {
            ((GroupCR)this.getInstance()).getTypeExtensions().add(typeExtension);
            return this;
        }

        public Builder typeExtensions(TypeExtensionTO ... typeExtensions) {
            ((GroupCR)this.getInstance()).getTypeExtensions().addAll(List.of(typeExtensions));
            return this;
        }

        public Builder typeExtensions(Collection<TypeExtensionTO> typeExtensions) {
            ((GroupCR)this.getInstance()).getTypeExtensions().addAll(typeExtensions);
            return this;
        }
    }
}

