/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scimv11.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.tirasa.connid.bundles.scimv11.dto.BaseEntity;
import net.tirasa.connid.bundles.scimv11.dto.SCIMAttribute;
import net.tirasa.connid.bundles.scimv11.dto.SCIMComplex;
import net.tirasa.connid.bundles.scimv11.dto.SCIMDefault;
import net.tirasa.connid.bundles.scimv11.dto.SCIMMeta;
import net.tirasa.connid.bundles.scimv11.dto.SCIMSchema;
import net.tirasa.connid.bundles.scimv11.dto.SCIMUserAddress;
import net.tirasa.connid.bundles.scimv11.dto.SCIMUserName;
import net.tirasa.connid.bundles.scimv11.service.SCIMv11Service;
import net.tirasa.connid.bundles.scimv11.types.AddressCanonicalType;
import net.tirasa.connid.bundles.scimv11.types.EmailCanonicalType;
import net.tirasa.connid.bundles.scimv11.types.IMCanonicalType;
import net.tirasa.connid.bundles.scimv11.types.PhoneNumberCanonicalType;
import net.tirasa.connid.bundles.scimv11.types.PhotoCanonicalType;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Attributes;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Utils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;

public class User
implements BaseEntity {
    @JsonIgnore
    private static final Log LOG = Log.getLog(User.class);
    @JsonProperty
    private String id;
    @JsonProperty
    private String externalId;
    @JsonProperty
    private SCIMMeta meta;
    @JsonProperty
    private String userName;
    @JsonProperty
    private SCIMUserName name;
    @JsonProperty
    private String password;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private String nickName;
    @JsonProperty
    private String profileUrl;
    @JsonProperty
    private String title;
    @JsonProperty
    private String userType;
    @JsonProperty
    private String preferredLanguage;
    @JsonProperty
    private String locale;
    @JsonProperty
    private String timezone;
    @JsonProperty
    private Boolean active;
    @JsonProperty
    private final List<SCIMComplex<EmailCanonicalType>> emails = new ArrayList<SCIMComplex<EmailCanonicalType>>();
    @JsonProperty
    private final List<SCIMComplex<PhoneNumberCanonicalType>> phoneNumbers = new ArrayList<SCIMComplex<PhoneNumberCanonicalType>>();
    @JsonProperty
    private final List<SCIMComplex<IMCanonicalType>> ims = new ArrayList<SCIMComplex<IMCanonicalType>>();
    @JsonProperty
    private final List<SCIMComplex<PhotoCanonicalType>> photos = new ArrayList<SCIMComplex<PhotoCanonicalType>>();
    @JsonProperty
    private final List<SCIMUserAddress> addresses = new ArrayList<SCIMUserAddress>();
    @JsonProperty
    private final List<SCIMDefault> groups = new ArrayList<SCIMDefault>();
    @JsonProperty
    private final List<SCIMDefault> roles = new ArrayList<SCIMDefault>();
    @JsonProperty
    private final List<SCIMDefault> entitlements = new ArrayList<SCIMDefault>();
    @JsonProperty
    private final List<SCIMDefault> x509Certificates = new ArrayList<SCIMDefault>();
    @JsonProperty
    private final List<String> schemas = new ArrayList<String>();
    @JsonIgnore
    private final Map<SCIMAttribute, List<Object>> scimCustomAttributes = new HashMap<SCIMAttribute, List<Object>>();
    @JsonIgnore
    private final Map<String, List<Object>> returnedCustomAttributes = new HashMap<String, List<Object>>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public SCIMUserName getName() {
        return this.name;
    }

    public void setName(SCIMUserName name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public SCIMMeta getMeta() {
        return this.meta;
    }

    public void setMeta(SCIMMeta meta) {
        this.meta = meta;
    }

    public List<SCIMComplex<EmailCanonicalType>> getEmails() {
        return this.emails;
    }

    public List<SCIMComplex<PhoneNumberCanonicalType>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public List<SCIMComplex<IMCanonicalType>> getIms() {
        return this.ims;
    }

    public List<SCIMComplex<PhotoCanonicalType>> getPhotos() {
        return this.photos;
    }

    public List<SCIMUserAddress> getAddresses() {
        return this.addresses;
    }

    public List<SCIMDefault> getX509Certificates() {
        return this.x509Certificates;
    }

    public List<SCIMDefault> getGroups() {
        return this.groups;
    }

    public List<SCIMDefault> getRoles() {
        return this.roles;
    }

    public List<SCIMDefault> getEntitlements() {
        return this.entitlements;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonIgnore
    public Map<SCIMAttribute, List<Object>> getSCIMCustomAttributes() {
        return this.scimCustomAttributes;
    }

    @JsonIgnore
    public Map<String, List<Object>> getReturnedCustomAttributes() {
        return this.returnedCustomAttributes;
    }

    @JsonIgnore
    public void fillSCIMCustomAttributes(Set<Attribute> attributes, String customAttributesJSON) {
        SCIMSchema customAttributesObj = SCIMv11Service.extractSCIMSchemas(customAttributesJSON);
        if (customAttributesObj != null) {
            block0: for (Attribute attribute : attributes) {
                if (CollectionUtil.isEmpty((Collection)attribute.getValue())) continue;
                for (SCIMAttribute customAttribute : customAttributesObj.getAttributes()) {
                    String externalAttributeName = customAttribute.getSchema().concat(".").concat(customAttribute.getName());
                    if (!externalAttributeName.equals(attribute.getName())) continue;
                    this.scimCustomAttributes.put(customAttribute, attribute.getValue());
                    continue block0;
                }
            }
        }
    }

    @Override
    @JsonIgnore
    public Set<Attribute> toAttributes() throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        for (Field field : fields = User.class.getDeclaredFields()) {
            ArrayList obj;
            Iterator sCIMComplex4;
            Object objInstance = field.get(this);
            if (field.isAnnotationPresent(JsonIgnore.class) || SCIMv11Utils.isEmptyObject(objInstance)) continue;
            field.setAccessible(true);
            if (field.getGenericType().toString().contains(SCIMComplex.class.getName())) {
                SCIMComplex sCIMComplex2;
                SCIMComplex sCIMComplex3;
                if (field.getGenericType().toString().contains(PhoneNumberCanonicalType.class.getName())) {
                    if (field.getType().equals(List.class)) {
                        for (Iterator sCIMComplex4 : new ArrayList((List)objInstance)) {
                            this.addAttribute(((SCIMComplex)((Object)sCIMComplex4)).toAttributes("phoneNumbers"), attrs, field.getType());
                        }
                        continue;
                    }
                    sCIMComplex3 = (SCIMComplex)objInstance;
                    this.addAttribute(sCIMComplex3.toAttributes("phoneNumbers"), attrs, field.getType());
                    continue;
                }
                if (field.getGenericType().toString().contains(IMCanonicalType.class.getName())) {
                    if (field.getType().equals(List.class)) {
                        obj = new ArrayList((List)objInstance);
                        sCIMComplex4 = obj.iterator();
                        while (sCIMComplex4.hasNext()) {
                            sCIMComplex2 = (SCIMComplex)sCIMComplex4.next();
                            this.addAttribute(sCIMComplex2.toAttributes("ims"), attrs, field.getType());
                        }
                        continue;
                    }
                    sCIMComplex3 = (SCIMComplex)objInstance;
                    this.addAttribute(sCIMComplex3.toAttributes("ims"), attrs, field.getType());
                    continue;
                }
                if (field.getGenericType().toString().contains(EmailCanonicalType.class.getName())) {
                    if (field.getType().equals(List.class)) {
                        obj = new ArrayList((List)objInstance);
                        sCIMComplex4 = obj.iterator();
                        while (sCIMComplex4.hasNext()) {
                            sCIMComplex2 = (SCIMComplex)sCIMComplex4.next();
                            this.addAttribute(sCIMComplex2.toAttributes("emails"), attrs, field.getType());
                        }
                        continue;
                    }
                    sCIMComplex3 = (SCIMComplex)objInstance;
                    this.addAttribute(sCIMComplex3.toAttributes("emails"), attrs, field.getType());
                    continue;
                }
                if (!field.getGenericType().toString().contains(PhotoCanonicalType.class.getName())) continue;
                if (field.getType().equals(List.class)) {
                    obj = new ArrayList((List)objInstance);
                    sCIMComplex4 = obj.iterator();
                    while (sCIMComplex4.hasNext()) {
                        sCIMComplex2 = (SCIMComplex)sCIMComplex4.next();
                        this.addAttribute(sCIMComplex2.toAttributes("photos"), attrs, field.getType());
                    }
                    continue;
                }
                sCIMComplex3 = (SCIMComplex)objInstance;
                this.addAttribute(sCIMComplex3.toAttributes("photos"), attrs, field.getType());
                continue;
            }
            if (field.getGenericType().toString().contains(SCIMUserName.class.getName())) {
                if (field.getType().equals(List.class)) {
                    obj = new ArrayList((List)objInstance);
                    sCIMComplex4 = obj.iterator();
                    while (sCIMComplex4.hasNext()) {
                        SCIMUserName sCIMUserName = (SCIMUserName)sCIMComplex4.next();
                        this.addAttribute(sCIMUserName.toAttributes(), attrs, field.getType());
                    }
                    continue;
                }
                this.addAttribute(((SCIMUserName)SCIMUserName.class.cast(objInstance)).toAttributes(), attrs, field.getType());
                continue;
            }
            if (field.getGenericType().toString().contains(SCIMUserAddress.class.getName())) {
                if (field.getType().equals(List.class)) {
                    obj = new ArrayList((List)objInstance);
                    sCIMComplex4 = obj.iterator();
                    while (sCIMComplex4.hasNext()) {
                        SCIMUserAddress sCIMUserAddress = (SCIMUserAddress)sCIMComplex4.next();
                        this.addAttribute(sCIMUserAddress.toAttributes(), attrs, field.getType());
                    }
                    continue;
                }
                this.addAttribute(((SCIMUserAddress)SCIMUserAddress.class.cast(objInstance)).toAttributes(), attrs, field.getType());
                continue;
            }
            if (field.getGenericType().toString().contains(SCIMDefault.class.getName())) {
                if (field.getType().equals(List.class)) {
                    obj = new ArrayList((List)objInstance);
                    sCIMComplex4 = obj.iterator();
                    while (sCIMComplex4.hasNext()) {
                        SCIMDefault sCIMDefault = (SCIMDefault)sCIMComplex4.next();
                        String localId = null;
                        if (StringUtil.isNotBlank((String)sCIMDefault.getValue())) {
                            if (this.entitlements.contains(sCIMDefault)) {
                                localId = "entitlements";
                            } else if (this.roles.contains(sCIMDefault)) {
                                localId = "roles";
                            } else if (this.groups.contains(sCIMDefault)) {
                                localId = "groups";
                            }
                        }
                        if (localId == null) continue;
                        this.addAttribute(sCIMDefault.toAttributes(localId), attrs, field.getType());
                    }
                    continue;
                }
                obj = (SCIMDefault)SCIMDefault.class.cast(objInstance);
                String localId = null;
                if (StringUtil.isNotBlank((String)((SCIMDefault)((Object)obj)).getValue())) {
                    if (this.entitlements.contains(obj)) {
                        localId = "entitlements";
                    } else if (this.roles.contains(obj)) {
                        localId = "roles";
                    } else if (this.groups.contains(obj)) {
                        localId = "groups";
                    }
                }
                if (localId == null) continue;
                this.addAttribute(((SCIMDefault)((Object)obj)).toAttributes(localId), attrs, field.getType());
                continue;
            }
            if (field.getGenericType().toString().contains(SCIMMeta.class.getName())) {
                if (field.getType().equals(List.class)) {
                    obj = new ArrayList((List)objInstance);
                    for (SCIMMeta sCIMMeta : obj) {
                        this.addAttribute(sCIMMeta.toAttributes(), attrs, field.getType());
                    }
                    continue;
                }
                this.addAttribute(((SCIMMeta)SCIMMeta.class.cast(objInstance)).toAttributes(), attrs, field.getType());
                continue;
            }
            attrs.add(SCIMv11Attributes.buildAttributeFromClassField(field, this).build());
        }
        return attrs;
    }

    @JsonIgnore
    private void addAttribute(Set<Attribute> toAttrs, Set<Attribute> attrs, Class<?> type) {
        for (Attribute toAttribute : toAttrs) {
            attrs.add(SCIMv11Attributes.doBuildAttributeFromClassField(toAttribute.getValue(), toAttribute.getName(), type).build());
        }
    }

    @Override
    @JsonIgnore
    public void fromAttributes(Set<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (CollectionUtil.isEmpty((Collection)attribute.getValue())) continue;
            try {
                this.doSetAttribute(attribute.getName(), attribute.getValue());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "While populating User field from ConnId attribute: {0}", new Object[]{attribute});
            }
        }
    }

    @JsonIgnore
    private void doSetAttribute(String name, List<Object> values) {
        Object value = values.get(0);
        switch (name) {
            case "userName": {
                this.userName = (String)String.class.cast(value);
                break;
            }
            case "name.formatted": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setFormatted((String)String.class.cast(value));
                break;
            }
            case "name.familyName": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setFamilyName((String)String.class.cast(value));
                break;
            }
            case "name.givenName": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setGivenName((String)String.class.cast(value));
                break;
            }
            case "name.middleName": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setMiddleName((String)String.class.cast(value));
                break;
            }
            case "name.honorificPrefix": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setHonorificPrefix((String)String.class.cast(value));
                break;
            }
            case "name.honorificSuffix": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setHonorificSuffix((String)String.class.cast(value));
                break;
            }
            case "meta.attributes": {
                if (this.meta == null) {
                    this.meta = new SCIMMeta();
                }
                this.meta.getAttributes().addAll(new ArrayList<Object>(values));
                break;
            }
            case "displayName": {
                this.displayName = (String)String.class.cast(value);
                break;
            }
            case "nickName": {
                this.nickName = (String)String.class.cast(value);
                break;
            }
            case "profileUrl": {
                this.profileUrl = (String)String.class.cast(value);
                break;
            }
            case "title": {
                this.title = (String)String.class.cast(value);
                break;
            }
            case "userType": {
                this.userType = (String)String.class.cast(value);
                break;
            }
            case "locale": {
                this.locale = (String)String.class.cast(value);
                break;
            }
            case "preferredLanguage": {
                this.preferredLanguage = (String)String.class.cast(value);
                break;
            }
            case "timezone": {
                this.timezone = (String)String.class.cast(value);
                break;
            }
            case "active": {
                this.active = (Boolean)Boolean.class.cast(value);
                break;
            }
            case "emails.work.value": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.work, this.emails);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "emails.work.primary": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.work, this.emails);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "emails.work.operation": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.work, this.emails);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "emails.home.value": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.home, this.emails);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "emails.home.primary": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.home, this.emails);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "emails.home.operation": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.home, this.emails);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "emails.other.value": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.other, this.emails);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "emails.other.primary": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.other, this.emails);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "emails.other.operation": {
                SCIMComplex<EmailCanonicalType> selected = this.handleSCIMComplexObject(EmailCanonicalType.other, this.emails);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.work.value": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.work, this.phoneNumbers);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.work.primary": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.work, this.phoneNumbers);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "phoneNumbers.work.operation": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.work, this.phoneNumbers);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.home.value": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.home, this.phoneNumbers);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.home.primary": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.home, this.phoneNumbers);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "phoneNumbers.home.operation": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.home, this.phoneNumbers);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.other.value": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.other, this.phoneNumbers);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.other.primary": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.other, this.phoneNumbers);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "phoneNumbers.other.operation": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.other, this.phoneNumbers);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.pager.value": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.pager, this.phoneNumbers);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.pager.primary": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.pager, this.phoneNumbers);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "phoneNumbers.pager.operation": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.pager, this.phoneNumbers);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.fax.value": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.fax, this.phoneNumbers);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.fax.primary": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.fax, this.phoneNumbers);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "phoneNumbers.fax.operation": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.fax, this.phoneNumbers);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.mobile.value": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.mobile, this.phoneNumbers);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "phoneNumbers.mobile.primary": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.mobile, this.phoneNumbers);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "phoneNumbers.mobile.operation": {
                SCIMComplex<PhoneNumberCanonicalType> selected = this.handleSCIMComplexObject(PhoneNumberCanonicalType.mobile, this.phoneNumbers);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.aim.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.aim, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.aim.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.aim, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.aim.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.aim, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.xmpp.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.xmpp, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.xmpp.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.xmpp, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.xmpp.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.xmpp, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.skype.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.skype, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.skype.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.skype, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.skype.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.skype, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.qq.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.qq, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.qq.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.qq, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.qq.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.qq, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.yahoo.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.yahoo, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.yahoo.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.yahoo, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.yahoo.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.yahoo, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.msn.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.msn, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.msn.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.msn, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.msn.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.msn, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.icq.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.icq, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.icq.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.icq, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.icq.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.icq, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "ims.gtalk.value": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.gtalk, this.ims);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "ims.gtalk.primary": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.gtalk, this.ims);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "ims.gtalk.operation": {
                SCIMComplex<IMCanonicalType> selected = this.handleSCIMComplexObject(IMCanonicalType.gtalk, this.ims);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "photos.photo.value": {
                SCIMComplex<PhotoCanonicalType> selected = this.handleSCIMComplexObject(PhotoCanonicalType.photo, this.photos);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "photos.photo.primary": {
                SCIMComplex<PhotoCanonicalType> selected = this.handleSCIMComplexObject(PhotoCanonicalType.photo, this.photos);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "photos.photo.operation": {
                SCIMComplex<PhotoCanonicalType> selected = this.handleSCIMComplexObject(PhotoCanonicalType.photo, this.photos);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "photos.thumbnail.value": {
                SCIMComplex<PhotoCanonicalType> selected = this.handleSCIMComplexObject(PhotoCanonicalType.thumbnail, this.photos);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "photos.thumbnail.primary": {
                SCIMComplex<PhotoCanonicalType> selected = this.handleSCIMComplexObject(PhotoCanonicalType.thumbnail, this.photos);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "photos.thumbnail.operation": {
                SCIMComplex<PhotoCanonicalType> selected = this.handleSCIMComplexObject(PhotoCanonicalType.thumbnail, this.photos);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "addresses.work.streetAddress": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setStreetAddress((String)String.class.cast(value));
                break;
            }
            case "addresses.work.locality": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setLocality((String)String.class.cast(value));
                break;
            }
            case "addresses.work.formatted": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setFormatted((String)String.class.cast(value));
                break;
            }
            case "addresses.work.region": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setRegion((String)String.class.cast(value));
                break;
            }
            case "addresses.work.postalCode": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setPostalCode((String)String.class.cast(value));
                break;
            }
            case "addresses.work.country": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setCountry((String)String.class.cast(value));
                break;
            }
            case "addresses.work.primary": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "addresses.work.operation": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.work);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "addresses.home.streetAddress": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setStreetAddress((String)String.class.cast(value));
                break;
            }
            case "addresses.home.locality": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setLocality((String)String.class.cast(value));
                break;
            }
            case "addresses.home.formatted": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setFormatted((String)String.class.cast(value));
                break;
            }
            case "addresses.home.region": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setRegion((String)String.class.cast(value));
                break;
            }
            case "addresses.home.postalCode": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setPostalCode((String)String.class.cast(value));
                break;
            }
            case "addresses.home.country": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setCountry((String)String.class.cast(value));
                break;
            }
            case "addresses.home.primary": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "addresses.home.operation": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.home);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "addresses.other.streetAddress": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setStreetAddress((String)String.class.cast(value));
                break;
            }
            case "addresses.other.locality": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setLocality((String)String.class.cast(value));
                break;
            }
            case "addresses.other.formatted": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setFormatted((String)String.class.cast(value));
                break;
            }
            case "addresses.other.region": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setRegion((String)String.class.cast(value));
                break;
            }
            case "addresses.other.postalCode": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setPostalCode((String)String.class.cast(value));
                break;
            }
            case "addresses.other.country": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setCountry((String)String.class.cast(value));
                break;
            }
            case "addresses.other.primary": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setPrimary((Boolean)Boolean.class.cast(value));
                break;
            }
            case "addresses.other.operation": {
                SCIMUserAddress selected = this.handleSCIMUserAddressObject(AddressCanonicalType.other);
                selected.setOperation((String)String.class.cast(value));
                break;
            }
            case "roles.default.value": {
                SCIMDefault selected = this.handleSCIMDefaultObject((String)String.class.cast(value), this.roles);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "entitlements.default.value": {
                SCIMDefault selected = this.handleSCIMDefaultObject((String)String.class.cast(value), this.entitlements);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "x509Certificates.default.value": {
                SCIMDefault selected = this.handleSCIMDefaultObject((String)String.class.cast(value), this.x509Certificates);
                selected.setValue((String)String.class.cast(value));
                break;
            }
            case "schemas": {
                this.schemas.addAll(new ArrayList<Object>(values));
                break;
            }
        }
    }

    @JsonIgnore
    private SCIMDefault handleSCIMDefaultObject(String value, List<SCIMDefault> list) {
        SCIMDefault selected = null;
        for (SCIMDefault scimDefault : list) {
            if (!scimDefault.getValue().equals(value)) continue;
            selected = scimDefault;
            break;
        }
        if (selected == null) {
            selected = new SCIMDefault();
            list.add(selected);
        }
        return selected;
    }

    @JsonIgnore
    private <T extends Enum<?>> SCIMComplex<T> handleSCIMComplexObject(T type, List<SCIMComplex<T>> list) {
        SCIMComplex<T> selected = null;
        for (SCIMComplex<T> complex : list) {
            if (!((Enum)complex.getType()).equals(type)) continue;
            selected = complex;
            break;
        }
        if (selected == null) {
            selected = new SCIMComplex<T>();
            selected.setType(type);
            list.add(selected);
        }
        return selected;
    }

    @JsonIgnore
    private SCIMUserAddress handleSCIMUserAddressObject(AddressCanonicalType type) {
        SCIMUserAddress selected = null;
        for (SCIMUserAddress complex : this.addresses) {
            if (!complex.getType().equals((Object)type)) continue;
            selected = complex;
            break;
        }
        if (selected == null) {
            selected = new SCIMUserAddress();
            selected.setType(type);
            this.addresses.add(selected);
        }
        return selected;
    }

    public String toString() {
        return "User{id=" + this.id + ", externalId=" + this.externalId + ", meta=" + this.meta + ", userName=" + this.userName + ", name=" + this.name + ", password=" + this.password + ", displayName=" + this.displayName + ", nickName=" + this.nickName + ", profileUrl=" + this.profileUrl + ", title=" + this.title + ", userType=" + this.userType + ", preferredLanguage=" + this.preferredLanguage + ", locale=" + this.locale + ", timezone=" + this.timezone + ", active=" + this.active + ", emails=" + this.emails + ", phoneNumbers=" + this.phoneNumbers + ", ims=" + this.ims + ", photos=" + this.photos + ", groups=" + this.groups + ", roles=" + this.roles + ", addresses=" + this.addresses + ", x509Certificates=" + this.x509Certificates + ", schemas=" + this.schemas + ", entitlements=" + this.entitlements + ", scimCustomAttributes=" + this.scimCustomAttributes + ", returnedCustomAttributes=" + this.returnedCustomAttributes + '}';
    }
}

