/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.service.UserService;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.apache.syncope.ext.scimv2.cxf.service.AbstractService;

public class UserServiceImpl
extends AbstractService<SCIMUser>
implements UserService {
    public UserServiceImpl(UserDAO userDAO, GroupDAO groupDAO, UserLogic userLogic, GroupLogic groupLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        super(userDAO, groupDAO, userLogic, groupLogic, binder, confManager);
    }

    public Response create(SCIMUser user) {
        ProvisioningResult result = this.userLogic.create(this.binder.toUserCR(user), false);
        return this.createResponse(((UserTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMUser((UserTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((UserTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()));
    }

    public SCIMUser get(String id, String attributes, String excludedAttributes) {
        return this.binder.toSCIMUser(this.userLogic.read(id), this.uriInfo.getAbsolutePathBuilder().build(new Object[0]).toASCIIString(), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
    }

    public Response update(String id) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    public Response replace(String id, SCIMUser user) {
        if (!id.equals(user.getId())) {
            throw new BadRequestException(ErrorType.invalidPath, "Expected " + id + ", found " + user.getId());
        }
        Response.ResponseBuilder builder = this.checkETag(Resource.User, id);
        if (builder != null) {
            return builder.build();
        }
        ProvisioningResult result = this.userLogic.update(AnyOperations.diff((UserTO)this.binder.toUserTO(user), (UserTO)this.userLogic.read(id), (boolean)false), false);
        return this.updateResponse(((UserTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMUser((UserTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((UserTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()));
    }

    public Response delete(String id) {
        Response.ResponseBuilder builder = this.checkETag(Resource.User, id);
        if (builder != null) {
            return builder.build();
        }
        this.anyLogic(Resource.User).delete(id, false);
        return Response.noContent().build();
    }

    public ListResponse<SCIMUser> search(String attributes, String excludedAttributes, String filter, String sortBy, SortOrder sortOrder, Integer startIndex, Integer count) {
        SCIMSearchRequest request = new SCIMSearchRequest(filter, sortBy, sortOrder, startIndex, count);
        if (attributes != null) {
            request.getAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))));
        }
        if (excludedAttributes != null) {
            request.getExcludedAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
        }
        return this.doSearch(Resource.User, request);
    }

    public ListResponse<SCIMUser> search(SCIMSearchRequest request) {
        return this.doSearch(Resource.User, request);
    }
}

