/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.time.OffsetDateTime;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.panels.SCIMConfTabPanel;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMGeneralConf;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCIMConfGeneralPanel
extends SCIMConfTabPanel {
    private static final long serialVersionUID = 2765863608539154422L;
    private static final Logger LOG = LoggerFactory.getLogger(SCIMConfGeneralPanel.class);

    public SCIMConfGeneralPanel(String id, SCIMConf scimConf) {
        super(id);
        final SCIMGeneralConf scimGeneralConf = scimConf.getGeneralConf();
        AjaxDateTimeFieldPanel creationDatePanel = new AjaxDateTimeFieldPanel("creationDate", "creationDate", (IModel)new Model<Date>(){
            private static final long serialVersionUID = 7075312408615929880L;

            public Date getObject() {
                return DateOps.convert((OffsetDateTime)scimGeneralConf.getCreationDate());
            }

            public void setObject(Date object) {
                scimGeneralConf.setCreationDate(DateOps.convert((Date)object));
            }
        }, DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
        creationDatePanel.setEnabled(false);
        AjaxDateTimeFieldPanel lastChangeDatePanel = new AjaxDateTimeFieldPanel("lastChangeDate", "lastChangeDate", (IModel)new Model<Date>(){
            private static final long serialVersionUID = 7075312408615929880L;

            public Date getObject() {
                return DateOps.convert((OffsetDateTime)scimGeneralConf.getLastChangeDate());
            }

            public void setObject(Date object) {
                scimGeneralConf.setLastChangeDate(DateOps.convert((Date)object));
            }
        }, DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
        lastChangeDatePanel.setEnabled(false);
        AjaxTextFieldPanel bulkMaxOperationsPanel = new AjaxTextFieldPanel("bulkMaxOperations", "bulkMaxOperations", (IModel)new PropertyModel<String>((Object)"bulkMaxOperations", "bulkMaxOperations"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return String.valueOf(scimGeneralConf.getBulkMaxOperations());
            }

            public void setObject(String object) {
                try {
                    scimGeneralConf.setBulkMaxOperations(Integer.parseInt(object));
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid value provided for 'bulkMaxOperations': {}", (Object)object, (Object)e);
                }
            }
        });
        bulkMaxOperationsPanel.setChoices(this.plainSchemaNames);
        AjaxTextFieldPanel bulkMaxMaxPayloadSizePanel = new AjaxTextFieldPanel("bulkMaxMaxPayloadSize", "bulkMaxMaxPayloadSize", (IModel)new PropertyModel<String>((Object)"bulkMaxMaxPayloadSize", "bulkMaxMaxPayloadSize"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return String.valueOf(scimGeneralConf.getBulkMaxPayloadSize());
            }

            public void setObject(String object) {
                try {
                    scimGeneralConf.setBulkMaxPayloadSize(Integer.parseInt(object));
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid value provided for 'bulkMaxPayloadSize': {}", (Object)object, (Object)e);
                }
            }
        });
        bulkMaxMaxPayloadSizePanel.setChoices(this.plainSchemaNames);
        AjaxTextFieldPanel filterMaxResultsPanel = new AjaxTextFieldPanel("filterMaxResults", "filterMaxResults", (IModel)new PropertyModel<String>((Object)"filterMaxResults", "filterMaxResults"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return String.valueOf(scimGeneralConf.getFilterMaxResults());
            }

            public void setObject(String object) {
                try {
                    scimGeneralConf.setFilterMaxResults(Integer.parseInt(object));
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid value provided for 'filterMaxResults': {}", (Object)object, (Object)e);
                }
            }
        });
        filterMaxResultsPanel.setChoices(this.plainSchemaNames);
        AjaxTextFieldPanel eTagValuePanel = new AjaxTextFieldPanel("eTagValue", "eTagValue", (IModel)new PropertyModel<String>((Object)"eTagValue", "eTagValue"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return scimGeneralConf.getETagValue();
            }

            public void setObject(String object) {
            }
        });
        eTagValuePanel.setEnabled(false);
        this.add(new Component[]{creationDatePanel});
        this.add(new Component[]{lastChangeDatePanel});
        this.add(new Component[]{bulkMaxOperationsPanel});
        this.add(new Component[]{bulkMaxMaxPayloadSizePanel});
        this.add(new Component[]{filterMaxResultsPanel});
        this.add(new Component[]{eTagValuePanel});
    }
}

