/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.fiql.FiqlParser;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apereo.cas.configuration.model.support.syncope.SyncopePrincipalAttributesProperties;
import org.apereo.cas.syncope.SyncopeUserTOConverterUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.services.persondir.IPersonAttributeDaoFilter;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.BasePersonAttributeDao;
import org.apereo.services.persondir.support.NamedPersonImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class SyncopePersonAttributeDao
extends BasePersonAttributeDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopePersonAttributeDao.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final FiqlParser<SearchBean> FIQL_PARSER = new FiqlParser(SearchBean.class);
    private final SyncopePrincipalAttributesProperties properties;

    public SyncopePersonAttributeDao(SyncopePrincipalAttributesProperties properties) {
        this.properties = properties;
        this.visit(properties.getSearchFilter());
    }

    private static Map<String, List<Object>> stuffAttributesIntoList(Map<String, ?> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (List)CollectionUtils.toCollection(entry.getValue(), ArrayList.class)));
    }

    public IPersonAttributes getPerson(String uid, IPersonAttributeDaoFilter filter) {
        HashMap attributes = new HashMap();
        FunctionUtils.doUnchecked(u -> this.syncopeSearch(uid).filter(sr -> sr.has("result")).ifPresent(sr -> {
            Iterator result = sr.get("result").iterator();
            if (result.hasNext()) {
                attributes.putAll(SyncopeUserTOConverterUtils.convert((JsonNode)result.next()));
            }
        }), (Object[])new Object[0]);
        return new NamedPersonImpl(uid, attributes);
    }

    public Set<IPersonAttributes> getPeople(Map<String, Object> map, IPersonAttributeDaoFilter filter) {
        return this.getPeopleWithMultivaluedAttributes(SyncopePersonAttributeDao.stuffAttributesIntoList(map), filter);
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> map, IPersonAttributeDaoFilter filter) {
        return map.entrySet().stream().filter(e -> this.properties.getSearchFilter().contains((CharSequence)e.getKey()) && e.getValue() != null && !((List)e.getValue()).isEmpty()).findFirst().map(e -> Set.of(this.getPerson(((List)e.getValue()).get(0).toString(), filter))).orElseGet(() -> new LinkedHashSet(0));
    }

    protected Set<String> visit(String searchFilter) {
        SearchCondition sc = FIQL_PARSER.parse(searchFilter);
        LinkedHashSet<String> searchProperties = new LinkedHashSet<String>();
        this.visitCompound((SearchCondition<SearchBean>)new OrSearchCondition(List.of(sc)), searchProperties);
        return searchProperties;
    }

    protected void visitCompound(SearchCondition<SearchBean> sc, Set<String> properties) {
        sc.getSearchConditions().forEach(searchCond -> {
            if (searchCond.getStatement() == null) {
                this.visitCompound((SearchCondition<SearchBean>)searchCond, properties);
            } else {
                properties.add(this.visitPrimitive((SearchCondition<SearchBean>)searchCond));
            }
        });
    }

    protected String visitPrimitive(SearchCondition<SearchBean> sc) {
        return sc.getStatement().getProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<JsonNode> syncopeSearch(String value) throws Exception {
        HttpResponse response;
        block2: {
            Optional<JsonNode> optional;
            response = null;
            try {
                String fiql = EncodingUtils.urlEncode((String)this.properties.getSearchFilter().replace("{user}", value).replace("{0}", value));
                String syncopeRestUrl = StringUtils.appendIfMissing((String)this.properties.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "rest/users/?page=1&size=1&details=true&fiql=" + fiql;
                LOGGER.debug("Executing Syncope search via [{}]", (Object)syncopeRestUrl);
                LinkedHashMap<String, String> requestHeaders = new LinkedHashMap<String, String>();
                requestHeaders.put("X-Syncope-Domain", this.properties.getDomain());
                requestHeaders.putAll(this.properties.getHeaders());
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).url(syncopeRestUrl).basicAuthUsername(this.properties.getBasicAuthUsername()).basicAuthPassword(this.properties.getBasicAuthPassword()).headers(requestHeaders).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getStatusLine());
                if (response.getStatusLine().getStatusCode() != 200) break block2;
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                LOGGER.debug("Received user object as [{}]", (Object)result);
                optional = Optional.of(MAPPER.readTree(result));
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return optional;
        }
        HttpUtils.close((HttpResponse)response);
        return Optional.empty();
    }
}

