/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestClient
implements RestClient {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseRestClient.class);
    private static final long serialVersionUID = 1523999867826481989L;

    public static SyncopeService getSyncopeService() {
        return BaseRestClient.getService(SyncopeService.class);
    }

    protected static <T> T getService(Class<T> serviceClass) {
        return (T)SyncopeEnduserSession.get().getService(serviceClass);
    }

    protected static <T> T getService(String etag, Class<T> serviceClass) {
        return (T)SyncopeEnduserSession.get().getService(etag, serviceClass);
    }

    protected static <T> void resetClient(Class<T> serviceClass) {
        SyncopeEnduserSession.get().resetClient(serviceClass);
    }

    protected static String toOrderBy(SortParam<String> sort) {
        OrderByClauseBuilder builder = SyncopeClient.getOrderByClauseBuilder();
        String property = (String)sort.getProperty();
        if (property.indexOf(35) != -1) {
            property = property.substring(property.indexOf(35) + 1);
        }
        if (sort.isAscending()) {
            builder.asc(property);
        } else {
            builder.desc(property);
        }
        return builder.build();
    }
}

