/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedJEESessionStore
implements SessionStore {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedJEESessionStore.class);
    public static final String DEFAULT_BEAN_NAME = "samlIdPDistributedSessionStore";
    private static final String SESSION_ID_IN_REQUEST_ATTRIBUTE = "sessionIdInRequestAttribute";
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final CasCookieBuilder cookieGenerator;

    public Optional<String> getSessionId(WebContext webContext, boolean create) {
        String sessionId = this.fetchSessionIdFromContext(webContext);
        if (StringUtils.isBlank((CharSequence)sessionId) && create) {
            sessionId = UUID.randomUUID().toString();
            LOGGER.trace("Generated session id: [{}]", (Object)sessionId);
            JEEContext context = (JEEContext)JEEContext.class.cast(webContext);
            this.cookieGenerator.addCookie(context.getNativeRequest(), context.getNativeResponse(), sessionId);
            context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, (Object)sessionId);
        }
        return Optional.ofNullable(sessionId);
    }

    public Optional get(WebContext context, String key) {
        LOGGER.trace("Getting key: [{}]", (Object)key);
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (ticket == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ticket.getProperties().get(key));
    }

    public void set(WebContext context, String key, Object value) {
        LOGGER.trace("Setting key: [{}]", (Object)key);
        String sessionId = this.getSessionId(context, true).get();
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        if (value instanceof Serializable) {
            properties.put(key, (Serializable)value);
        } else if (value != null) {
            LOGGER.warn("Object value [{}] assigned to [{}] is not serializable and may not be part of the ticket [{}]", new Object[]{value, key, sessionId});
        }
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (value == null && ticket != null) {
            ticket.getProperties().remove(key);
            FunctionUtils.doUnchecked(s -> this.ticketRegistry.updateTicket((Ticket)ticket), (Object[])new Object[0]);
        } else if (ticket == null) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            TransientSessionTicket created = transientFactory.create(sessionId, properties);
            FunctionUtils.doUnchecked(s -> this.ticketRegistry.addTicket((Ticket)created), (Object[])new Object[0]);
        } else {
            ticket.getProperties().putAll(properties);
            FunctionUtils.doUnchecked(s -> this.ticketRegistry.updateTicket((Ticket)ticket), (Object[])new Object[0]);
        }
    }

    public boolean destroySession(WebContext webContext) {
        String sessionId = this.fetchSessionIdFromContext(webContext);
        if (sessionId != null) {
            String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
            FunctionUtils.doUnchecked(s -> this.ticketRegistry.deleteTicket(ticketId), (Object[])new Object[0]);
            JEEContext context = (JEEContext)JEEContext.class.cast(webContext);
            this.cookieGenerator.removeCookie(context.getNativeResponse());
            LOGGER.trace("Removes session cookie and ticket: [{}]", (Object)ticketId);
        }
        return true;
    }

    public Optional getTrackableSession(WebContext context) {
        String sessionId = this.fetchSessionIdFromContext(context);
        LOGGER.trace("Track sessionId: [{}]", (Object)sessionId);
        return Optional.ofNullable(sessionId);
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, trackableSession);
        LOGGER.trace("Force sessionId: [{}]", trackableSession);
        return Optional.of(this);
    }

    public boolean renewSession(WebContext context) {
        return false;
    }

    protected String fetchSessionIdFromContext(WebContext webContext) {
        String sessionId = webContext.getRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE).orElse(null);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            JEEContext context = (JEEContext)JEEContext.class.cast(webContext);
            sessionId = this.cookieGenerator.retrieveCookieValue(context.getNativeRequest());
        }
        LOGGER.trace("Fetched session id: [{}]", (Object)sessionId);
        return sessionId;
    }

    private TransientSessionTicket getTransientSessionTicketForSession(WebContext context) {
        try {
            String sessionId = this.fetchSessionIdFromContext(context);
            if (sessionId != null) {
                String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
                LOGGER.trace("fetching ticket: [{}]", (Object)ticketId);
                return (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
            }
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Generated
    public DistributedJEESessionStore(TicketRegistry ticketRegistry, TicketFactory ticketFactory, CasCookieBuilder cookieGenerator) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.cookieGenerator = cookieGenerator;
    }
}

