/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AuthModuleLogic
extends AbstractTransactionalLogic<AuthModuleTO> {
    protected final AuthModuleDataBinder binder;
    protected final AuthModuleDAO authModuleDAO;

    public AuthModuleLogic(AuthModuleDataBinder binder, AuthModuleDAO authModuleDAO) {
        this.binder = binder;
        this.authModuleDAO = authModuleDAO;
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_CREATE')")
    public AuthModuleTO create(AuthModuleTO authModuleTO) {
        return this.binder.getAuthModuleTO(this.authModuleDAO.save(this.binder.create(authModuleTO)));
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_UPDATE')")
    public AuthModuleTO update(AuthModuleTO authModuleTO) {
        AuthModule authModule = this.authModuleDAO.find(authModuleTO.getKey());
        if (authModule == null) {
            throw new NotFoundException("AuthModule " + authModuleTO.getKey() + " not found");
        }
        return this.binder.getAuthModuleTO(this.authModuleDAO.save(this.binder.update(authModule, authModuleTO)));
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_LIST') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<AuthModuleTO> list() {
        return this.authModuleDAO.findAll().stream().map(arg_0 -> ((AuthModuleDataBinder)this.binder).getAuthModuleTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_READ')")
    @Transactional(readOnly=true)
    public AuthModuleTO read(String key) {
        AuthModule authModule = this.authModuleDAO.find(key);
        if (authModule == null) {
            throw new NotFoundException("AuthModule " + key + " not found");
        }
        return this.binder.getAuthModuleTO(authModule);
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_DELETE')")
    public AuthModuleTO delete(String key) {
        AuthModule authModule = this.authModuleDAO.find(key);
        if (authModule == null) {
            throw new NotFoundException("AuthModule " + key + " not found");
        }
        AuthModuleTO deleted = this.binder.getAuthModuleTO(authModule);
        this.authModuleDAO.delete(authModule);
        return deleted;
    }

    protected AuthModuleTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof AuthModuleTO)) continue;
                key = ((AuthModuleTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAuthModuleTO(this.authModuleDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

