/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.BucketConsumptionResult;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorAuthenticationProvider;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CasSimpleMultifactorSendTokenAction
extends AbstractMultifactorAuthenticationAction<CasSimpleMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorSendTokenAction.class);
    private static final String MESSAGE_MFA_TOKEN_SENT = "cas.mfa.simple.label.tokensent";
    private final CommunicationsManager communicationsManager;
    private final CasSimpleMultifactorAuthenticationService multifactorAuthenticationService;
    private final CasSimpleMultifactorAuthenticationProperties properties;
    private final CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy;
    private final BucketConsumer bucketConsumer;

    protected boolean isSmsSent(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties, Principal principal, Ticket token, RequestContext requestContext) {
        if (communicationsManager.isSmsSenderDefined()) {
            SmsProperties smsProperties = properties.getSms();
            String smsText = StringUtils.isNotBlank((CharSequence)smsProperties.getText()) ? SmsBodyBuilder.builder().properties(smsProperties).parameters(Map.of("token", token.getId())).build().get() : token.getId();
            SmsRequest smsRequest = SmsRequest.builder().from(smsProperties.getFrom()).principal(principal).attribute(smsProperties.getAttributeName()).text(smsText).build();
            return communicationsManager.sms(smsRequest);
        }
        return false;
    }

    protected EmailCommunicationResult isMailSent(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties, Principal principal, Ticket token, RequestContext requestContext) {
        if (communicationsManager.isMailSenderDefined()) {
            EmailProperties mailProperties = properties.getMail();
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            Map parameters = CoreAuthenticationUtils.convertAttributeValuesToObjects((Map)principal.getAttributes());
            parameters.put("token", token.getId());
            Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
            String body = EmailMessageBodyBuilder.builder().properties(mailProperties).locale(locale).parameters(parameters).build().get();
            EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(mailProperties).principal(principal).attribute(mailProperties.getAttributeName()).body(body).build();
            return communicationsManager.email(emailRequest);
        }
        return EmailCommunicationResult.builder().build();
    }

    protected boolean isNotificationSent(CommunicationsManager communicationsManager, Principal principal, Ticket token) {
        return communicationsManager.isNotificationSenderDefined() && communicationsManager.notify(principal, "Apereo CAS Token", String.format("Token: %s", token.getId()));
    }

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        Authentication authentication = WebUtils.getInProgressAuthentication();
        BucketConsumptionResult result = this.bucketConsumer.consume(this.getThrottledRequestKeyFor(authentication));
        result.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
        return result.isConsumed() ? super.doPreExecute(requestContext) : this.error();
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        boolean notificationSent;
        Authentication authentication = WebUtils.getInProgressAuthentication();
        Principal principal = this.resolvePrincipal(authentication.getPrincipal());
        CasSimpleMultifactorAuthenticationTicket token = this.getOrCreateToken(requestContext, principal);
        LOGGER.debug("Using token [{}] created at [{}]", (Object)token.getId(), (Object)token.getCreationTime());
        EnumSet<CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions> strategy = this.tokenCommunicationStrategy.determineStrategy(token);
        boolean smsSent = strategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.SMS) && this.isSmsSent(this.communicationsManager, this.properties, principal, token, requestContext);
        boolean emailSent = strategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.EMAIL) && this.isMailSent(this.communicationsManager, this.properties, principal, token, requestContext).isSuccess();
        boolean bl = notificationSent = strategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.NOTIFICATION) && this.isNotificationSent(this.communicationsManager, principal, token);
        if (smsSent || emailSent || notificationSent) {
            this.multifactorAuthenticationService.store(token);
            LOGGER.debug("Successfully submitted token via strategy option [{}] to [{}]", strategy, (Object)principal.getId());
            WebUtils.addInfoMessageToContext((RequestContext)requestContext, (String)MESSAGE_MFA_TOKEN_SENT);
            LocalAttributeMap attributes = new LocalAttributeMap("token", (Object)token.getId());
            WebUtils.putSimpleMultifactorAuthenticationToken((RequestContext)requestContext, (Ticket)token);
            return new EventFactorySupport().event((Object)this, "success", (AttributeMap)attributes);
        }
        LOGGER.error("Communication strategies failed to submit token [{}] to user", (Object)token.getId());
        return this.error();
    }

    protected CasSimpleMultifactorAuthenticationTicket getOrCreateToken(RequestContext requestContext, Principal principal) {
        CasSimpleMultifactorAuthenticationTicket currentToken = (CasSimpleMultifactorAuthenticationTicket)WebUtils.getSimpleMultifactorAuthenticationToken((RequestContext)requestContext, CasSimpleMultifactorAuthenticationTicket.class);
        return Optional.ofNullable(currentToken).filter(token -> !token.isExpired()).orElseGet(Unchecked.supplier(() -> {
            WebUtils.removeSimpleMultifactorAuthenticationToken((RequestContext)requestContext);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            return this.multifactorAuthenticationService.generate(principal, (Service)service);
        }));
    }

    private String getThrottledRequestKeyFor(Authentication authentication) {
        Principal principal = this.resolvePrincipal(authentication.getPrincipal());
        return principal.getId();
    }

    @Generated
    public CasSimpleMultifactorSendTokenAction(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationService multifactorAuthenticationService, CasSimpleMultifactorAuthenticationProperties properties, CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy, BucketConsumer bucketConsumer) {
        this.communicationsManager = communicationsManager;
        this.multifactorAuthenticationService = multifactorAuthenticationService;
        this.properties = properties;
        this.tokenCommunicationStrategy = tokenCommunicationStrategy;
        this.bucketConsumer = bucketConsumer;
    }
}

