/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webmvc;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.support.RequestDataValueProcessor;
import org.thymeleaf.spring5.context.IThymeleafRequestDataValueProcessor;

class SpringWebMvcThymeleafRequestDataValueProcessor
implements IThymeleafRequestDataValueProcessor {
    private final RequestDataValueProcessor requestDataValueProcessor;
    private final HttpServletRequest httpServletRequest;

    SpringWebMvcThymeleafRequestDataValueProcessor(RequestDataValueProcessor requestDataValueProcessor, HttpServletRequest httpServletRequest) {
        this.requestDataValueProcessor = requestDataValueProcessor;
        this.httpServletRequest = httpServletRequest;
    }

    @Override
    public String processAction(String action, String httpMethod) {
        if (this.requestDataValueProcessor == null) {
            return action;
        }
        return this.requestDataValueProcessor.processAction(this.httpServletRequest, action, httpMethod);
    }

    @Override
    public String processFormFieldValue(String name, String value, String type) {
        if (this.requestDataValueProcessor == null) {
            return value;
        }
        return this.requestDataValueProcessor.processFormFieldValue(this.httpServletRequest, name, value, type);
    }

    @Override
    public Map<String, String> getExtraHiddenFields() {
        if (this.requestDataValueProcessor == null) {
            return null;
        }
        return this.requestDataValueProcessor.getExtraHiddenFields(this.httpServletRequest);
    }

    @Override
    public String processUrl(String url) {
        if (this.requestDataValueProcessor == null) {
            return url;
        }
        return this.requestDataValueProcessor.processUrl(this.httpServletRequest, url);
    }
}

