/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form.preview;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.syncope.client.ui.commons.annotations.BinaryPreview;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IOUtils;

@BinaryPreview(mimeTypes={"application/json", "application/xml", "application/yaml", "application/x-yaml", "text/x-yaml", "text/yaml"})
public class BinaryTextPreviewer
extends BinaryPreviewer {
    private static final long serialVersionUID = 3808379310090668773L;
    private String previewerId;

    public BinaryTextPreviewer(String id, String mimeType) {
        super(id, mimeType);
    }

    @Override
    public Component preview(byte[] uploadedBytes) {
        Fragment fragment = new Fragment("preview", "noPreviewFragment", (MarkupContainer)this);
        if (uploadedBytes.length > 0) {
            try {
                fragment = new Fragment("preview", "previewFragment", (MarkupContainer)this);
                ByteArrayInputStream stream = new ByteArrayInputStream(uploadedBytes);
                TextArea previewer = new TextArea("previewer", (IModel)Model.of((Serializable)((Object)IOUtils.toString((InputStream)stream))));
                previewer.setOutputMarkupPlaceholderTag(true);
                this.previewerId = previewer.getMarkupId();
                fragment.add(new Component[]{previewer});
            }
            catch (IOException e) {
                LOG.error("Error evaluating text file", (Throwable)e);
            }
        }
        WebMarkupContainer previewContainer = new WebMarkupContainer("previewContainer");
        previewContainer.setOutputMarkupId(true);
        previewContainer.add(new Component[]{fragment});
        return this.addOrReplace(new Component[]{previewContainer});
    }

    public void renderHead(IHeaderResponse response) {
        String options;
        super.renderHead(response);
        switch (this.mimeType) {
            case "application/json": {
                options = "matchBrackets: true, autoCloseBrackets: true,";
                break;
            }
            case "application/xml": {
                options = "autoCloseTags: true, mode: 'text/html',";
                break;
            }
            case "application/yaml": 
            case "application/x-yaml": 
            case "text/x-yaml": 
            case "text/yaml": {
                options = "mode: 'yaml',";
                break;
            }
            default: {
                options = "mode: 'text/html',";
            }
        }
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)("var editor = CodeMirror.fromTextArea(document.getElementById('" + this.previewerId + "'), {  readOnly: true,   lineNumbers: true,   lineWrapping: false, " + options + "  autoRefresh: true});editor.setSize('900', 250)")));
    }
}

