/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SinglePushJobDelegate
extends PushJobDelegate
implements SyncopeSinglePushExecutor {
    @Autowired
    protected ImplementationDAO implementationDAO;

    protected void before(ExternalResource resource, Connector connector, PushTaskTO pushTaskTO, String executor) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)resource);
        PushTask pushTask = (PushTask)this.entityFactory.newEntity(PushTask.class);
        pushTask.setResource(resource);
        pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
        pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
        pushTask.setPerformCreate(pushTaskTO.isPerformCreate());
        pushTask.setPerformUpdate(pushTaskTO.isPerformUpdate());
        pushTask.setPerformDelete(pushTaskTO.isPerformDelete());
        pushTask.setSyncStatus(pushTaskTO.isSyncStatus());
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        this.profile.setExecutor(executor);
        this.profile.getActions().addAll(this.getPushActions(pushTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())));
        this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
        for (PushActions action : this.profile.getActions()) {
            action.beforeAll(this.profile);
        }
    }

    public List<ProvisioningReport> push(ExternalResource resource, Provision provision, Connector connector, Any<?> any, PushTaskTO pushTaskTO, String executor) throws JobExecutionException {
        try {
            UserPushResultHandler handler;
            this.before(resource, connector, pushTaskTO, executor);
            AnyType anyType = this.anyTypeDAO.find(provision.getAnyType());
            switch (anyType.getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            this.doHandle(List.of(any), (SyncopePushResultHandler)handler, resource);
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }

    public ProvisioningReport push(ExternalResource resource, Provision provision, Connector connector, LinkedAccount account, PushTaskTO pushTaskTO, String executor) throws JobExecutionException {
        try {
            this.before(resource, connector, pushTaskTO, executor);
            UserPushResultHandler handler = this.buildUserHandler();
            handler.setProfile(this.profile);
            handler.handle(account, provision);
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return (ProvisioningReport)this.profile.getResults().get(0);
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }
}

