/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SinglePullJobDelegate
extends PullJobDelegate
implements SyncopeSinglePullExecutor {
    @Autowired
    protected ImplementationDAO implementationDAO;
    @Autowired
    protected RealmDAO realmDAO;

    public List<ProvisioningReport> pull(ExternalResource resource, Provision provision, Connector connector, ReconFilterBuilder reconFilterBuilder, Set<String> moreAttrsToGet, PullTaskTO pullTaskTO, String executor) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)resource);
        try {
            GroupPullResultHandler handler;
            PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
            pullTask.setResource(resource);
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            pullTask.setPullMode(PullMode.FILTERED_RECONCILIATION);
            pullTask.setPerformCreate(pullTaskTO.isPerformCreate());
            pullTask.setPerformUpdate(pullTaskTO.isPerformUpdate());
            pullTask.setPerformDelete(pullTaskTO.isPerformDelete());
            pullTask.setSyncStatus(pullTaskTO.isSyncStatus());
            pullTask.setDestinationRealm(this.realmDAO.findByFullPath(pullTaskTO.getDestinationRealm()));
            pullTask.setRemediation(pullTaskTO.isRemediation());
            TemplateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            pullTaskTO.getTemplates().forEach((type, template) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    AnyTemplatePullTask anyTemplate = pullTask.getTemplate(anyType.getKey()).orElse(null);
                    if (anyTemplate == null) {
                        anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                        anyTemplate.setAnyType(anyType);
                        anyTemplate.setPullTask(pullTask);
                        pullTask.add(anyTemplate);
                    }
                    anyTemplate.set(template);
                }
            });
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
            this.profile.setDryRun(false);
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            this.profile.getActions().addAll(this.getPullActions(pullTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())));
            this.profile.setExecutor(executor);
            for (PullActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
            AnyType anyType = this.anyTypeDAO.find(provision.getAnyType());
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            switch (anyType.getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            HashSet<String> matg = new HashSet<String>(moreAttrsToGet);
            this.profile.getActions().forEach(a -> matg.addAll(a.moreAttrsToGet(this.profile, provision)));
            Stream<Item> mapItems = Stream.concat(MappingUtils.getPullItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.find(pullTask.getResource().getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
            connector.filteredReconciliation(new ObjectClass(provision.getObjectClass()), reconFilterBuilder, (SyncResultsHandler)handler, MappingUtils.buildOperationOptions(mapItems, (String[])matg.toArray(String[]::new)));
            try {
                this.setGroupOwners(ghandler);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (PullActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pulling from connector", (Throwable)e);
        }
    }
}

