/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractRealmResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultRealmPullResultHandler
extends AbstractRealmResultHandler<PullTask, PullActions>
implements RealmPullResultHandler {
    @Autowired
    private InboundMatcher inboundMatcher;
    @Autowired
    private ConnObjectUtils connObjectUtils;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private CASSPClientAppDAO casSPClientAppDAO;
    @Autowired
    private OIDCRPClientAppDAO oidcRPClientAppDAO;
    @Autowired
    private SAML2SPClientAppDAO saml2SPClientAppDAO;
    private SyncopePullExecutor executor;
    private AuditElements.Result latestResult;

    public void setPullExecutor(SyncopePullExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(SyncDelta delta) {
        try {
            boolean shouldContinue;
            OrgUnit orgUnit = ((PullTask)this.profile.getTask()).getResource().getOrgUnit();
            if (orgUnit == null) {
                throw new JobExecutionException("No orgUnit found on " + ((PullTask)this.profile.getTask()).getResource() + " for " + delta.getObject().getObjectClass());
            }
            this.doHandle(delta, orgUnit);
            this.executor.reportHandled(delta.getObjectClass().getObjectClassValue(), delta.getObject().getName());
            LOG.debug("Successfully handled {}", (Object)delta);
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                return true;
            }
            DefaultRealmPullResultHandler defaultRealmPullResultHandler = this;
            synchronized (defaultRealmPullResultHandler) {
                shouldContinue = this.latestResult == AuditElements.Result.SUCCESS;
                this.latestResult = null;
            }
            if (shouldContinue) {
                this.executor.setLatestSyncToken(delta.getObjectClass().getObjectClassValue(), delta.getToken());
            }
            return shouldContinue;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setAnyType("REALM");
            ignoreResult.setKey(null);
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            this.executor.setLatestSyncToken(delta.getObjectClass().getObjectClassValue(), delta.getToken());
            this.executor.reportHandled(delta.getObjectClass().getObjectClassValue(), delta.getObject().getName());
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    private List<ProvisioningReport> assign(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta);
            return List.of();
        }
        RealmTO realmTO = this.connObjectUtils.getRealmTO(delta.getObject(), orgUnit);
        if (realmTO.getFullPath() == null) {
            if (realmTO.getParent() == null) {
                realmTO.setParent(((PullTask)this.profile.getTask()).getDestinationRealm().getFullPath());
            }
            realmTO.setFullPath(realmTO.getParent() + "/" + realmTO.getName());
        }
        realmTO.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(realmTO.getFullPath());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta);
        } else {
            for (PullActions action : this.profile.getActions()) {
                action.beforeAssign(this.profile, delta, realmTO);
            }
            this.create(realmTO, delta, UnmatchingRule.ASSIGN, result);
        }
        return List.of(result);
    }

    private List<ProvisioningReport> provision(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return List.of();
        }
        RealmTO realmTO = this.connObjectUtils.getRealmTO(delta.getObject(), orgUnit);
        if (realmTO.getFullPath() == null) {
            if (realmTO.getParent() == null) {
                realmTO.setParent(((PullTask)this.profile.getTask()).getDestinationRealm().getFullPath());
            }
            realmTO.setFullPath(realmTO.getParent() + "/" + realmTO.getName());
        }
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(realmTO.getFullPath());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta);
        } else {
            for (PullActions action : this.profile.getActions()) {
                action.beforeProvision(this.profile, delta, realmTO);
            }
            this.create(realmTO, delta, UnmatchingRule.PROVISION, result);
        }
        return List.of(result);
    }

    private void throwIgnoreProvisionException(SyncDelta delta, Exception exception) throws JobExecutionException {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (PullActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    private void create(RealmTO realmTO, SyncDelta delta, UnmatchingRule unmatchingRule, ProvisioningReport result) throws JobExecutionException {
        AuditElements.Result resultStatus;
        Throwable output;
        try {
            Realm realm = this.realmDAO.save(this.binder.create(((PullTask)this.profile.getTask()).getDestinationRealm(), realmTO));
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.CREATE, (Collection)realm.getResourceKeys());
            if (unmatchingRule == UnmatchingRule.ASSIGN) {
                List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
                this.taskExecutor.execute((Collection)taskInfos, false, this.securityProperties.getAdminUser());
            }
            RealmTO actual = this.binder.getRealmTO(realm, true);
            result.setKey(actual.getKey());
            result.setName(((PullTask)this.profile.getTask()).getDestinationRealm().getFullPath() + "/" + actual.getName());
            output = actual;
            resultStatus = AuditElements.Result.SUCCESS;
            for (PullActions action : this.profile.getActions()) {
                action.after(this.profile, delta, (EntityTO)actual, result);
            }
            LOG.debug("Realm {} successfully created", (Object)actual.getKey());
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        catch (Exception e) {
            this.throwIgnoreProvisionException(delta, e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create Realm {} ", (Object)delta.getUid().getUidValue(), (Object)e);
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        this.finalize(UnmatchingRule.toEventName((UnmatchingRule)unmatchingRule), resultStatus, null, output, delta);
    }

    private List<ProvisioningReport> update(SyncDelta delta, List<Realm> realms, boolean inLink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta);
            return List.of();
        }
        LOG.debug("About to update {}", realms);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (Realm realm : realms) {
            LOG.debug("About to update {}", (Object)realm);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(realm.getKey());
            result.setName(realm.getFullPath());
            if (!this.profile.isDryRun()) {
                AuditElements.Result resultStatus;
                Throwable output;
                RealmTO before = this.binder.getRealmTO(realm, true);
                try {
                    if (!inLink) {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, delta, (EntityTO)before, null);
                        }
                    }
                    Map beforeAttrs = this.propagationManager.prepareAttrs(realm);
                    PropagationByResource propByRes = this.binder.update(realm, before);
                    realm = this.realmDAO.save(realm);
                    RealmTO updated = this.binder.getRealmTO(realm, true);
                    List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.createTasks(realm, propByRes, null), beforeAttrs, null);
                    this.taskExecutor.execute((Collection)taskInfos, false, this.securityProperties.getAdminUser());
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)updated, result);
                    }
                    output = updated;
                    resultStatus = AuditElements.Result.SUCCESS;
                    result.setName(updated.getFullPath());
                    LOG.debug("{} successfully updated", (Object)updated);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                this.finalize(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta);
            }
            results.add(result);
        }
        return results;
    }

    private List<ProvisioningReport> deprovision(SyncDelta delta, List<Realm> realms, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return List.of();
        }
        LOG.debug("About to deprovision {}", realms);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (Realm realm : realms) {
            LOG.debug("About to unassign resource {}", (Object)realm);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(realm.getKey());
            result.setName(realm.getFullPath());
            if (!this.profile.isDryRun()) {
                AuditElements.Result resultStatus;
                Throwable output;
                RealmTO before = this.binder.getRealmTO(realm, true);
                try {
                    RealmTO realmTO;
                    if (unlink) {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, delta, (EntityTO)before);
                        }
                    } else {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                        }
                    }
                    PropagationByResource propByRes = new PropagationByResource();
                    propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)((PullTask)this.profile.getTask()).getResource().getKey()));
                    this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, null), false, this.securityProperties.getAdminUser());
                    if (unlink) {
                        realm.getResources().remove(((PullTask)this.profile.getTask()).getResource());
                        realmTO = this.binder.getRealmTO(this.realmDAO.save(realm), true);
                    } else {
                        realmTO = this.binder.getRealmTO(realm, true);
                    }
                    output = realmTO;
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)realmTO, result);
                    }
                    resultStatus = AuditElements.Result.SUCCESS;
                    LOG.debug("{} successfully updated", (Object)realm);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), resultStatus, before, output, delta);
            }
            results.add(result);
        }
        return results;
    }

    private List<ProvisioningReport> link(SyncDelta delta, List<Realm> realms, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), AuditElements.Result.SUCCESS, null, null, delta);
            return List.of();
        }
        LOG.debug("About to link {}", realms);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (Realm realm : realms) {
            LOG.debug("About to unassign resource {}", (Object)realm);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(realm.getKey());
            result.setName(realm.getFullPath());
            if (!this.profile.isDryRun()) {
                AuditElements.Result resultStatus;
                Object output;
                RealmTO before = this.binder.getRealmTO(realm, true);
                try {
                    if (unlink) {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, delta, (EntityTO)before);
                        }
                    } else {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, delta, (EntityTO)before);
                        }
                    }
                    if (unlink) {
                        realm.getResources().remove(((PullTask)this.profile.getTask()).getResource());
                    } else {
                        realm.add(((PullTask)this.profile.getTask()).getResource());
                    }
                    output = this.update(delta, List.of(realm), true);
                    resultStatus = AuditElements.Result.SUCCESS;
                    LOG.debug("{} successfully updated", (Object)realm);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta);
            }
            results.add(result);
        }
        return results;
    }

    private List<ProvisioningReport> delete(SyncDelta delta, List<Realm> realms) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.finalize(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta);
            return List.of();
        }
        LOG.debug("About to delete {}", realms);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        realms.forEach(realm -> {
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            RealmTO before = this.binder.getRealmTO(realm, true);
            try {
                result.setKey(realm.getKey());
                result.setName(realm.getFullPath());
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType("REALM");
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                if (!this.profile.isDryRun()) {
                    Exception output;
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, delta, (EntityTO)before);
                    }
                    try {
                        if (!this.realmDAO.findChildren(realm).isEmpty()) {
                            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
                        }
                        Set<String> adminRealms = Set.of(realm.getFullPath());
                        AnyCond keyCond = new AnyCond(AttrCond.Type.ISNOTNULL);
                        keyCond.setSchema("key");
                        SearchCond allMatchingCond = SearchCond.getLeaf((AbstractSearchCond)keyCond);
                        int users = this.searchDAO.count(this.realmDAO.getRoot(), true, adminRealms, allMatchingCond, AnyTypeKind.USER);
                        int groups = this.searchDAO.count(this.realmDAO.getRoot(), true, adminRealms, allMatchingCond, AnyTypeKind.GROUP);
                        int anyObjects = this.searchDAO.count(this.realmDAO.getRoot(), true, adminRealms, allMatchingCond, AnyTypeKind.ANY_OBJECT);
                        int macroTasks = this.taskDAO.findByRealm(realm).size();
                        int clientApps = this.casSPClientAppDAO.findByRealm(realm).size() + this.saml2SPClientAppDAO.findByRealm(realm).size() + this.oidcRPClientAppDAO.findByRealm(realm).size();
                        if (users + groups + anyObjects + macroTasks + clientApps > 0) {
                            SyncopeClientException realmContains = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
                            realmContains.getElements().add(users + " user(s)");
                            realmContains.getElements().add(groups + " group(s)");
                            realmContains.getElements().add(anyObjects + " anyObject(s)");
                            realmContains.getElements().add(macroTasks + " command task(s)");
                            realmContains.getElements().add(clientApps + " client app(s)");
                            throw realmContains;
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        propByRes.addAll(ResourceOperation.DELETE, (Collection)realm.getResourceKeys());
                        List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
                        this.taskExecutor.execute((Collection)taskInfos, false, this.securityProperties.getAdminUser());
                        this.realmDAO.delete(realm);
                        output = null;
                        resultStatus = AuditElements.Result.SUCCESS;
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)before, result);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete {}", realm, (Object)e);
                        output = e;
                    }
                    this.finalize(ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta);
                }
                results.add(result);
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read Realm {}", realm, (Object)e);
            }
            catch (Exception e) {
                LOG.error("Could not delete Realm {}", realm, (Object)e);
            }
        });
        return results;
    }

    private ProvisioningReport ignore(SyncDelta delta, boolean matching) throws JobExecutionException {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ProvisioningReport result = new ProvisioningReport();
        result.setKey(null);
        result.setName(delta.getObject().getUid().getUidValue());
        result.setOperation(ResourceOperation.NONE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        if (!this.profile.isDryRun()) {
            this.finalize(matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta);
        }
        return result;
    }

    private void doHandle(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta finalDelta = delta;
        for (PullActions action : this.profile.getActions()) {
            finalDelta = action.preprocess(this.profile, finalDelta);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{finalDelta.getDeltaType(), finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass()});
        List<Realm> realms = this.inboundMatcher.match(finalDelta, orgUnit);
        LOG.debug("Match found for {} as {}: {}", new Object[]{finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass(), realms});
        if (realms.size() > 1) {
            switch (this.profile.getConflictResolutionAction()) {
                case IGNORE: {
                    throw new IgnoreProvisionException("More than one match found for " + finalDelta.getObject().getUid().getUidValue() + ": " + realms);
                }
                case FIRSTMATCH: {
                    realms = realms.subList(0, 1);
                    break;
                }
                case LASTMATCH: {
                    realms = realms.subList(realms.size() - 1, realms.size());
                    break;
                }
            }
        }
        try {
            block6 : switch (delta.getDeltaType()) {
                case CREATE: 
                case UPDATE: 
                case CREATE_OR_UPDATE: {
                    if (realms.isEmpty()) {
                        switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                            case ASSIGN: {
                                this.profile.getResults().addAll(this.assign(finalDelta, orgUnit));
                                break block6;
                            }
                            case PROVISION: {
                                this.profile.getResults().addAll(this.provision(finalDelta, orgUnit));
                                break block6;
                            }
                            case IGNORE: {
                                this.profile.getResults().add(this.ignore(finalDelta, false));
                                break block6;
                            }
                        }
                        break;
                    }
                    switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                        case UPDATE: {
                            this.profile.getResults().addAll(this.update(finalDelta, realms, false));
                            break block6;
                        }
                        case DEPROVISION: {
                            this.profile.getResults().addAll(this.deprovision(finalDelta, realms, false));
                            break block6;
                        }
                        case UNASSIGN: {
                            this.profile.getResults().addAll(this.deprovision(finalDelta, realms, true));
                            break block6;
                        }
                        case LINK: {
                            this.profile.getResults().addAll(this.link(finalDelta, realms, false));
                            break block6;
                        }
                        case UNLINK: {
                            this.profile.getResults().addAll(this.link(finalDelta, realms, true));
                            break block6;
                        }
                        case IGNORE: {
                            this.profile.getResults().add(this.ignore(finalDelta, true));
                            break block6;
                        }
                    }
                    break;
                }
                case DELETE: {
                    if (realms.isEmpty()) {
                        this.finalize(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, finalDelta);
                        LOG.debug("No match found for deletion");
                        break;
                    }
                    this.profile.getResults().addAll(this.delete(finalDelta, realms));
                    break;
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalize(String event, AuditElements.Result result, Object before, Object output, SyncDelta delta) {
        DefaultRealmPullResultHandler defaultRealmPullResultHandler = this;
        synchronized (defaultRealmPullResultHandler) {
            this.latestResult = result;
        }
        this.notificationManager.createTasks(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PULL, "REALM".toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta});
        this.auditManager.audit(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PULL, "REALM".toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta});
    }
}

