/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Base64;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class LDAPPasswordPropagationActions
implements PropagationActions {
    private static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    private UserDAO userDAO;

    @Transactional(readOnly=true)
    public void before(PropagationTaskInfo taskInfo) {
        if (AnyTypeKind.USER == taskInfo.getAnyTypeKind()) {
            User user = (User)this.userDAO.find(taskInfo.getEntityKey());
            PropagationData data = taskInfo.getPropagationData();
            if (user != null && user.getPassword() != null && data.getAttributes() != null) {
                Set attrs = data.getAttributes();
                Attribute missing = AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)attrs);
                ConnInstance connInstance = taskInfo.getResource().getConnector();
                String cipherAlgorithm = this.getCipherAlgorithm(connInstance);
                if (missing != null && missing.getValue() != null && missing.getValue().size() == 1 && missing.getValue().get(0).equals(OperationalAttributes.PASSWORD_NAME) && this.cipherAlgorithmMatches(this.getCipherAlgorithm(connInstance), user.getCipherAlgorithm())) {
                    String password = user.getPassword().toLowerCase();
                    byte[] decodedPassword = DatatypeConverter.parseHexBinary((String)password);
                    String base64EncodedPassword = Base64.getEncoder().encodeToString(decodedPassword);
                    String cipherPlusPassword = "{" + cipherAlgorithm.toLowerCase() + "}" + base64EncodedPassword;
                    Attribute passwordAttribute = AttributeBuilder.buildPassword((GuardedString)new GuardedString(cipherPlusPassword.toCharArray()));
                    attrs.add(passwordAttribute);
                    attrs.remove(missing);
                }
            }
        }
    }

    protected String getCipherAlgorithm(ConnInstance connInstance) {
        return connInstance.getConf().stream().filter(property -> "passwordHashAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty()).findFirst().map(cipherAlgorithm -> (String)cipherAlgorithm.getValues().get(0)).orElse(CLEARTEXT);
    }

    protected boolean cipherAlgorithmMatches(String connectorAlgo, CipherAlgorithm userAlgo) {
        if (userAlgo == null) {
            return false;
        }
        if (connectorAlgo.equals(userAlgo.name())) {
            return true;
        }
        return "SHA".equals(connectorAlgo) && userAlgo.name().startsWith("SHA") || "SSHA".equals(connectorAlgo) && userAlgo.name().startsWith("SSHA");
    }
}

