/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.report.ReconciliationReportletConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.ReportletConfClass;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.java.job.report.AbstractReportlet;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ReportletConfClass(value=ReconciliationReportletConf.class)
public class ReconciliationReportlet
extends AbstractReportlet {
    private static final int PAGE_SIZE = 10;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private ConnectorManager connectorManager;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private SearchCondVisitor searchCondVisitor;
    private ReconciliationReportletConf conf;

    private static String getAnyElementName(AnyTypeKind anyTypeKind) {
        String elementName;
        switch (anyTypeKind) {
            case USER: {
                elementName = "user";
                break;
            }
            case GROUP: {
                elementName = "group";
                break;
            }
            default: {
                elementName = "anyObject";
            }
        }
        return elementName;
    }

    private void doExtract(ContentHandler handler, Any<?> any, Set<Missing> missing, Set<Misaligned> misaligned) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        for (ReconciliationReportletConf.Feature feature : this.conf.getFeatures()) {
            String type = null;
            Object value = null;
            switch (feature) {
                case key: {
                    type = "xsd:string";
                    value = any.getKey();
                    break;
                }
                case username: {
                    if (!(any instanceof User)) break;
                    type = "xsd:string";
                    value = ((User)User.class.cast(any)).getUsername();
                    break;
                }
                case groupName: {
                    if (!(any instanceof Group)) break;
                    type = "xsd:string";
                    value = ((Group)Group.class.cast(any)).getName();
                    break;
                }
                case status: {
                    type = "xsd:string";
                    value = any.getStatus();
                    break;
                }
                case creationDate: {
                    type = "xsd:dateTime";
                    value = any.getCreationDate() == null ? "" : FormatUtils.format((TemporalAccessor)any.getCreationDate());
                    break;
                }
                case lastLoginDate: {
                    if (!(any instanceof User)) break;
                    type = "xsd:dateTime";
                    value = ((User)User.class.cast(any)).getLastLoginDate() == null ? "" : FormatUtils.format((TemporalAccessor)((User)User.class.cast(any)).getLastLoginDate());
                    break;
                }
                case changePwdDate: {
                    if (!(any instanceof User)) break;
                    type = "xsd:dateTime";
                    value = ((User)User.class.cast(any)).getChangePwdDate() == null ? "" : FormatUtils.format((TemporalAccessor)((User)User.class.cast(any)).getChangePwdDate());
                    break;
                }
                case passwordHistorySize: {
                    if (!(any instanceof User)) break;
                    type = "xsd:integer";
                    value = String.valueOf(((User)User.class.cast(any)).getPasswordHistory().size());
                    break;
                }
                case failedLoginCount: {
                    if (!(any instanceof User)) break;
                    type = "xsd:integer";
                    value = String.valueOf(((User)User.class.cast(any)).getFailedLogins());
                    break;
                }
            }
            if (type == null || value == null) continue;
            atts.addAttribute("", "", feature.name(), type, (String)value);
        }
        handler.startElement("", "", ReconciliationReportlet.getAnyElementName(any.getType().getKind()), atts);
        for (Missing missing2 : missing) {
            atts.clear();
            atts.addAttribute("", "", "resource", "xsd:string", missing2.getResource());
            atts.addAttribute("", "", "connObjectKeyValue", "xsd:string", missing2.getConnObjectKeyValue());
            handler.startElement("", "", "missing", atts);
            handler.endElement("", "", "missing");
        }
        for (Misaligned misaligned2 : misaligned) {
            char[] asChars;
            atts.clear();
            atts.addAttribute("", "", "resource", "xsd:string", misaligned2.getResource());
            atts.addAttribute("", "", "connObjectKeyValue", "xsd:string", misaligned2.getConnObjectKeyValue());
            atts.addAttribute("", "", "name", "xsd:string", misaligned2.getName());
            handler.startElement("", "", "misaligned", atts);
            handler.startElement("", "", "onSyncope", null);
            if (misaligned2.getOnSyncope() != null) {
                for (Object value : misaligned2.getOnSyncope()) {
                    asChars = value.toString().toCharArray();
                    handler.startElement("", "", "value", null);
                    handler.characters(asChars, 0, asChars.length);
                    handler.endElement("", "", "value");
                }
            }
            handler.endElement("", "", "onSyncope");
            handler.startElement("", "", "onResource", null);
            if (misaligned2.getOnResource() != null) {
                for (Object value : misaligned2.getOnResource()) {
                    asChars = value.toString().toCharArray();
                    handler.startElement("", "", "value", null);
                    handler.characters(asChars, 0, asChars.length);
                    handler.endElement("", "", "value");
                }
            }
            handler.endElement("", "", "onResource");
            handler.endElement("", "", "misaligned");
        }
        handler.endElement("", "", ReconciliationReportlet.getAnyElementName(any.getType().getKind()));
    }

    private static Set<Object> getValues(Attribute attr) {
        Set<Object> values;
        if (attr.getValue() == null || attr.getValue().isEmpty()) {
            values = Set.of();
        } else if (attr.getValue().get(0) instanceof byte[]) {
            values = new HashSet<Object>(attr.getValue().size());
            attr.getValue().forEach(single -> values.add(Base64.getEncoder().encode((byte[])single)));
        } else {
            values = new HashSet<Object>(attr.getValue());
        }
        return values;
    }

    private void doExtract(ContentHandler handler, List<? extends Any<?>> anys) throws SAXException, ReportException {
        HashSet<Missing> missing = new HashSet<Missing>();
        HashSet<Misaligned> misaligned = new HashSet<Misaligned>();
        for (Any<?> any : anys) {
            missing.clear();
            misaligned.clear();
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(any);
            anyUtils.getAllResources(any).forEach(resource -> {
                String connObjectKeyValue;
                Provision provision = resource.getProvisionByAnyType(any.getType().getKey()).orElse(null);
                Optional<Item> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
                String string = connObjectKeyValue = connObjectKeyItem.isPresent() ? (String)this.mappingManager.getConnObjectKeyValue(any, resource, provision).get() : "";
                if (provision != null && connObjectKeyItem.isPresent() && StringUtils.isNotBlank((CharSequence)connObjectKeyValue)) {
                    Connector connector = this.connectorManager.getConnector(resource);
                    ConnectorObject connectorObject = connector.getObject(new ObjectClass(provision.getObjectClass()), AttributeBuilder.build((String)connObjectKeyItem.get().getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), provision.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(provision.getMapping().getItems().stream(), new String[0]));
                    if (connectorObject == null) {
                        LOG.error("Object {} with class {} not found on resource {}", new Object[]{connObjectKeyValue, provision.getObjectClass(), resource});
                        missing.add(new Missing(resource.getKey(), connObjectKeyValue));
                    } else {
                        Pair preparedAttrs = this.mappingManager.prepareAttrsFromAny(any, null, false, null, resource, provision);
                        ((Set)preparedAttrs.getRight()).add(AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{preparedAttrs.getLeft()}));
                        ((Set)preparedAttrs.getRight()).add(AttributeBuilder.build((String)connObjectKeyItem.get().getExtAttrName(), (Object[])new Object[]{preparedAttrs.getLeft()}));
                        HashMap syncopeAttrs = new HashMap();
                        ((Set)preparedAttrs.getRight()).forEach(attr -> syncopeAttrs.put(attr.getName(), ReconciliationReportlet.getValues(attr)));
                        HashMap<String, Set> resourceAttrs = new HashMap<String, Set>();
                        connectorObject.getAttributes().stream().filter(attr -> !OperationalAttributes.PASSWORD_NAME.equals(attr.getName()) && !OperationalAttributes.ENABLE_NAME.equals(attr.getName())).forEachOrdered(attr -> resourceAttrs.put(attr.getName(), ReconciliationReportlet.getValues(attr)));
                        syncopeAttrs.keySet().stream().filter(syncopeAttr -> !resourceAttrs.containsKey(syncopeAttr)).forEach(name -> misaligned.add(new Misaligned(resource.getKey(), connObjectKeyValue, (String)name, (Set)syncopeAttrs.get(name), Set.of())));
                        resourceAttrs.forEach((key, values) -> {
                            if (syncopeAttrs.containsKey(key)) {
                                if (!Objects.equals(syncopeAttrs.get(key), values)) {
                                    misaligned.add(new Misaligned(resource.getKey(), connObjectKeyValue, (String)key, (Set)syncopeAttrs.get(key), (Set<Object>)values));
                                }
                            } else {
                                misaligned.add(new Misaligned(resource.getKey(), connObjectKeyValue, (String)key, Set.of(), (Set<Object>)values));
                            }
                        });
                    }
                }
            });
            if (missing.isEmpty() && misaligned.isEmpty()) continue;
            this.doExtract(handler, any, missing, misaligned);
        }
    }

    @Override
    protected void doExtract(ReportletConf conf, ContentHandler handler, AtomicReference<String> status) throws SAXException {
        int page;
        int pages;
        int total;
        int page2;
        int pages2;
        int total2;
        if (!(conf instanceof ReconciliationReportletConf)) {
            throw new ReportException(new IllegalArgumentException("Invalid configuration provided"));
        }
        this.conf = (ReconciliationReportletConf)ReconciliationReportletConf.class.cast(conf);
        AttributesImpl atts = new AttributesImpl();
        if (StringUtils.isBlank((CharSequence)this.conf.getUserMatchingCond())) {
            total2 = this.userDAO.count();
            pages2 = total2 / 500 + 1;
            status.set("Processing " + total2 + " users in " + pages2 + " pages");
            atts.addAttribute("", "", "total", "xsd:integer", String.valueOf(total2));
            handler.startElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.USER) + "s", atts);
            for (page2 = 1; page2 <= pages2; ++page2) {
                status.set("Processing " + total2 + " users: page " + page2 + " of " + pages2);
                this.doExtract(handler, this.userDAO.findAll(page2, 500));
            }
        } else {
            SearchCond cond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)this.conf.getUserMatchingCond(), (String[])new String[0]);
            total = this.searchDAO.count(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, AnyTypeKind.USER);
            pages = total / 500 + 1;
            status.set("Processing " + total + " users in " + pages + " pages");
            atts.addAttribute("", "", "total", "xsd:integer", String.valueOf(total));
            handler.startElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.USER) + "s", atts);
            for (page = 1; page <= pages; ++page) {
                status.set("Processing " + total + " users: page " + page + " of " + pages);
                this.doExtract(handler, this.searchDAO.search(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, page, 10, List.of(), AnyTypeKind.USER));
            }
        }
        handler.endElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.USER) + "s");
        atts.clear();
        if (StringUtils.isBlank((CharSequence)this.conf.getGroupMatchingCond())) {
            total2 = this.groupDAO.count();
            pages2 = total2 / 500 + 1;
            status.set("Processing " + total2 + " groups in " + pages2 + " pages");
            atts.addAttribute("", "", "total", "xsd:integer", String.valueOf(total2));
            handler.startElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.GROUP) + "s", atts);
            for (page2 = 1; page2 <= pages2; ++page2) {
                status.set("Processing " + total2 + " groups: page " + page2 + " of " + pages2);
                this.doExtract(handler, this.groupDAO.findAll(page2, 500));
            }
        } else {
            SearchCond cond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)this.conf.getUserMatchingCond(), (String[])new String[0]);
            total = this.searchDAO.count(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, AnyTypeKind.GROUP);
            pages = total / 500 + 1;
            status.set("Processing " + total + " groups in " + pages + " pages");
            atts.addAttribute("", "", "total", "xsd:integer", String.valueOf(total));
            handler.startElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.GROUP) + "s", atts);
            for (page = 1; page <= pages; ++page) {
                status.set("Processing " + total + " groups: page " + page + " of " + pages);
                this.doExtract(handler, this.searchDAO.search(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, page, 10, List.of(), AnyTypeKind.GROUP));
            }
        }
        handler.endElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.GROUP) + "s");
        for (AnyType anyType : this.anyTypeDAO.findAll()) {
            if (anyType.equals(this.anyTypeDAO.findUser()) || anyType.equals(this.anyTypeDAO.findGroup())) continue;
            AnyTypeCond anyTypeCond = new AnyTypeCond();
            anyTypeCond.setAnyTypeKey(anyType.getKey());
            SearchCond cond = StringUtils.isBlank((CharSequence)this.conf.getAnyObjectMatchingCond()) ? SearchCond.getLeaf((AbstractSearchCond)anyTypeCond) : SearchCond.getAnd((SearchCond)SearchCond.getLeaf((AbstractSearchCond)anyTypeCond), (SearchCond)SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)this.conf.getAnyObjectMatchingCond(), (String[])new String[0]));
            int total3 = this.searchDAO.count(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, AnyTypeKind.ANY_OBJECT);
            int pages3 = total3 / 500 + 1;
            status.set("Processing " + total3 + " any objects " + anyType.getKey() + " in " + pages3 + " pages");
            atts.clear();
            atts.addAttribute("", "", "type", "xsd:string", anyType.getKey());
            atts.addAttribute("", "", "total", "xsd:integer", String.valueOf(total3));
            handler.startElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.ANY_OBJECT) + "s", atts);
            for (int page3 = 1; page3 <= pages3; ++page3) {
                status.set("Processing " + total3 + " any objects " + anyType.getKey() + ": page " + page3 + " of " + pages3);
                this.doExtract(handler, this.searchDAO.search(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, page3, 10, List.of(), AnyTypeKind.ANY_OBJECT));
            }
            handler.endElement("", "", ReconciliationReportlet.getAnyElementName(AnyTypeKind.ANY_OBJECT) + "s");
        }
    }

    private static class Misaligned
    extends Missing {
        private final String name;
        private final Set<Object> onSyncope;
        private final Set<Object> onResource;

        Misaligned(String resource, String connObjectKeyValue, String name, Set<Object> onSyncope, Set<Object> onResource) {
            super(resource, connObjectKeyValue);
            this.name = name;
            this.onSyncope = onSyncope;
            this.onResource = onResource;
        }

        public String getName() {
            return this.name;
        }

        public Set<Object> getOnSyncope() {
            return this.onSyncope;
        }

        public Set<Object> getOnResource() {
            return this.onResource;
        }
    }

    private static class Missing {
        private final String resource;
        private final String connObjectKeyValue;

        Missing(String resource, String connObjectKeyValue) {
            this.resource = resource;
            this.connObjectKeyValue = connObjectKeyValue;
        }

        public String getResource() {
            return this.resource;
        }

        public String getConnObjectKeyValue() {
            return this.connObjectKeyValue;
        }
    }
}

