/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.DummyTrustManager;
import com.icegreen.greenmail.util.GreenMail;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummySSLServerSocketFactory
extends SSLServerSocketFactory {
    protected final Logger log = LoggerFactory.getLogger(GreenMail.class);
    public static final String GREENMAIL_KEYSTORE_FILE_PROPERTY = "greenmail.tls.keystore.file";
    public static final String GREENMAIL_KEYSTORE_PASSWORD_PROPERTY = "greenmail.tls.keystore.password";
    public static final String GREENMAIL_KEYSTORE_P12 = "greenmail.p12";
    public static final String GREENMAIL_KEYSTORE_JKS = "greenmail.jks";
    private final SSLServerSocketFactory factory;
    private final KeyStore ks;
    static final String[] ANONYMOUS_CIPHERS = new String[]{"SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA256", "TLS_DH_anon_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_256_CBC_SHA256", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA"};

    public DummySSLServerSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            String defaultAlg = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory km = KeyManagerFactory.getInstance(defaultAlg);
            this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] pass = System.getProperty(GREENMAIL_KEYSTORE_PASSWORD_PROPERTY, "changeit").toCharArray();
            this.loadKeyStore(pass);
            km.init(this.ks, pass);
            KeyManager[] kma = km.getKeyManagers();
            sslcontext.init(kma, new TrustManager[]{new DummyTrustManager()}, null);
            this.factory = sslcontext.getServerSocketFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create and initialize SSL", e);
        }
    }

    private void loadKeyStore(char[] pass) throws NoSuchAlgorithmException, CertificateException {
        String keystore = System.getProperty(GREENMAIL_KEYSTORE_FILE_PROPERTY);
        if (null != keystore) {
            this.loadKeystore(this.ks, pass, new File(keystore));
        } else {
            try {
                this.loadKeystore(this.ks, pass, GREENMAIL_KEYSTORE_P12);
            }
            catch (IllegalStateException ex) {
                this.loadKeystore(this.ks, pass, GREENMAIL_KEYSTORE_JKS);
            }
        }
    }

    private void loadKeystore(KeyStore keyStore, char[] pass, String keystoreResource) throws NoSuchAlgorithmException, CertificateException {
        this.log.debug("Loading keystore from resource {} ...", (Object)keystoreResource);
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(keystoreResource);){
            keyStore.load(is, pass);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can not load greenmail keystore from '" + keystoreResource + "' in classpath", ex);
        }
    }

    private void loadKeystore(KeyStore keyStore, char[] pass, File keystoreResource) throws NoSuchAlgorithmException, CertificateException {
        this.log.debug("Loading keystore from file {} ...", (Object)keystoreResource);
        try (FileInputStream is = new FileInputStream(keystoreResource);){
            keyStore.load(is, pass);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can not load greenmail keystore from file '" + keystoreResource + "'", ex);
        }
    }

    private SSLServerSocket addAnonCipher(ServerSocket socket) {
        SSLServerSocket ssl = (SSLServerSocket)socket;
        ssl.setEnabledCipherSuites(DummySSLServerSocketFactory.addAnonCiphers(ssl.getEnabledCipherSuites()));
        return ssl;
    }

    static String[] addAnonCiphers(String[] ciphers) {
        String[] newCiphers = new String[ciphers.length + ANONYMOUS_CIPHERS.length];
        System.arraycopy(ciphers, 0, newCiphers, 0, ciphers.length);
        System.arraycopy(ANONYMOUS_CIPHERS, 0, newCiphers, ciphers.length, ANONYMOUS_CIPHERS.length);
        return newCiphers;
    }

    public static ServerSocketFactory getDefault() {
        return Holder.INSTANCE.value;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.addAnonCipher(this.factory.createServerSocket());
    }

    @Override
    public ServerSocket createServerSocket(int i) throws IOException {
        return this.addAnonCipher(this.factory.createServerSocket(i));
    }

    @Override
    public ServerSocket createServerSocket(int i, int i1) throws IOException {
        return this.addAnonCipher(this.factory.createServerSocket(i, i1));
    }

    @Override
    public ServerSocket createServerSocket(int i, int i1, InetAddress inetAddress) throws IOException {
        return this.addAnonCipher(this.factory.createServerSocket(i, i1, inetAddress));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    public KeyStore getKeyStore() {
        return this.ks;
    }

    private static enum Holder {
        INSTANCE;

        final DummySSLServerSocketFactory value = new DummySSLServerSocketFactory();
    }
}

