/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.HierarchicalFolder;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.RootFolder;
import com.icegreen.greenmail.store.Store;
import com.icegreen.greenmail.store.StoredMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.Quota;

public class InMemoryStore
implements Store,
ImapConstants {
    boolean quotaSupported = true;
    private final RootFolder rootMailbox = new RootFolder();
    private final Map<String, Set<Quota>> quotaMap = new HashMap<String, Set<Quota>>();

    @Override
    public MailFolder getMailbox(String absoluteMailboxName) {
        String childName;
        HierarchicalFolder parent;
        StringTokenizer tokens = new StringTokenizer(absoluteMailboxName, HIERARCHY_DELIMITER);
        if (!tokens.hasMoreTokens() || !tokens.nextToken().equalsIgnoreCase("#mail")) {
            throw new IllegalStateException("Can not extract mail root '#mail' from  " + absoluteMailboxName);
        }
        for (parent = this.rootMailbox; parent != null && tokens.hasMoreTokens(); parent = parent.getChild(childName)) {
            childName = tokens.nextToken();
        }
        return parent;
    }

    @Override
    public MailFolder getMailbox(MailFolder parent, String name) {
        return ((HierarchicalFolder)parent).getChild(name);
    }

    @Override
    public MailFolder createMailbox(MailFolder parent, String mailboxName, boolean selectable) throws FolderException {
        if (mailboxName.indexOf(46) != -1) {
            throw new FolderException("Invalid mailbox name " + mailboxName);
        }
        HierarchicalFolder castParent = (HierarchicalFolder)parent;
        HierarchicalFolder child = castParent.createChild(mailboxName);
        child.setSelectable(selectable);
        return child;
    }

    @Override
    public void deleteMailbox(MailFolder folder) throws FolderException {
        HierarchicalFolder toDelete = (HierarchicalFolder)folder;
        if (toDelete.hasChildren()) {
            throw new FolderException("Cannot delete mailbox with children.");
        }
        if (toDelete.getMessageCount() != 0) {
            throw new FolderException("Cannot delete non-empty mailbox");
        }
        HierarchicalFolder parent = toDelete.getParent();
        parent.removeChild(toDelete);
    }

    @Override
    public void renameMailbox(MailFolder existingFolder, String newName) {
        String newFolderPathWithoutName;
        String newFolderName;
        HierarchicalFolder toRename = (HierarchicalFolder)existingFolder;
        HierarchicalFolder parent = toRename.getParent();
        int idx = newName.lastIndexOf(46);
        if (idx > 0) {
            newFolderName = newName.substring(idx + 1);
            newFolderPathWithoutName = newName.substring(0, idx);
        } else {
            newFolderName = newName;
            newFolderPathWithoutName = "";
        }
        if (parent.getName().equals(newFolderPathWithoutName)) {
            toRename.setName(newFolderName);
        } else {
            parent.removeChild(toRename);
            HierarchicalFolder userFolder = this.getInboxOrUserRootFolder(toRename);
            String[] path = newName.split('\\' + ImapConstants.HIERARCHY_DELIMITER);
            HierarchicalFolder newParent = userFolder;
            for (int i = 0; i < path.length - 1; ++i) {
                newParent = newParent.getChild(path[i]);
            }
            toRename.moveToNewParent(newParent);
            toRename.setName(newFolderName);
        }
    }

    private HierarchicalFolder getInboxOrUserRootFolder(HierarchicalFolder folder) {
        HierarchicalFolder inboxFolder = this.findParentByName(folder);
        if (null == inboxFolder) {
            return folder.getParent();
        }
        return inboxFolder.getParent();
    }

    private HierarchicalFolder findParentByName(HierarchicalFolder folder) {
        HierarchicalFolder currentFolder;
        for (currentFolder = folder; null != currentFolder && !"INBOX".equals(currentFolder.getName()); currentFolder = currentFolder.getParent()) {
        }
        return currentFolder;
    }

    @Override
    public Collection<MailFolder> getChildren(MailFolder parent) {
        return Collections.unmodifiableCollection(((HierarchicalFolder)parent).getChildren());
    }

    @Override
    public MailFolder setSelectable(MailFolder folder, boolean selectable) {
        ((HierarchicalFolder)folder).setSelectable(selectable);
        return folder;
    }

    @Override
    public Collection<MailFolder> listMailboxes(String searchPattern) throws FolderException {
        int starIndex = searchPattern.indexOf(42);
        int percentIndex = searchPattern.indexOf(37);
        if (starIndex > -1 && starIndex < searchPattern.length() - 1 || percentIndex > -1 && percentIndex < searchPattern.length() - 1) {
            throw new FolderException("Wildcard characters <" + searchPattern + "> are only handled as the last character of a list argument");
        }
        ArrayList<MailFolder> mailboxes = new ArrayList<MailFolder>();
        if (starIndex != -1 || percentIndex != -1) {
            int lastDot = searchPattern.lastIndexOf(HIERARCHY_DELIMITER);
            String parentName = lastDot < 0 ? "#mail" : searchPattern.substring(0, lastDot);
            String matchPattern = searchPattern.substring(lastDot + 1, searchPattern.length() - 1);
            HierarchicalFolder parent = (HierarchicalFolder)this.getMailbox(parentName);
            if (parent != null) {
                for (HierarchicalFolder child : parent.getChildren()) {
                    if (!child.getName().startsWith(matchPattern)) continue;
                    mailboxes.add(child);
                    if (starIndex == -1) continue;
                    this.addAllChildren(child, mailboxes);
                }
            }
        } else {
            MailFolder folder = this.getMailbox(searchPattern);
            if (folder != null) {
                mailboxes.add(folder);
            }
        }
        return mailboxes;
    }

    @Override
    public Quota[] getQuota(String root, String qualifiedRootPrefix) {
        HashSet<String> rootPaths = new HashSet<String>();
        if (!root.contains(ImapConstants.HIERARCHY_DELIMITER)) {
            rootPaths.add(qualifiedRootPrefix + root);
        } else {
            for (String r : root.split(ImapConstants.HIERARCHY_DELIMITER)) {
                rootPaths.add(qualifiedRootPrefix + r);
            }
        }
        rootPaths.add(qualifiedRootPrefix);
        HashSet<Quota> collectedQuotas = new HashSet<Quota>();
        for (String p : rootPaths) {
            Set<Quota> quotas = this.quotaMap.get(p);
            if (null == quotas) continue;
            collectedQuotas.addAll(quotas);
        }
        this.updateQuotas(collectedQuotas, qualifiedRootPrefix);
        return collectedQuotas.toArray(new Quota[0]);
    }

    private void updateQuotas(Set<Quota> quotas, String qualifiedRootPrefix) {
        for (Quota q : quotas) {
            this.updateQuota(q, qualifiedRootPrefix);
        }
    }

    private void updateQuota(Quota quota, String pQualifiedRootPrefix) {
        MailFolder folder = this.getMailbox("#mail" + ImapConstants.HIERARCHY_DELIMITER + pQualifiedRootPrefix + ImapConstants.HIERARCHY_DELIMITER + quota.quotaRoot);
        try {
            for (Quota.Resource r : quota.resources) {
                if ("STORAGE".equals(r.name)) {
                    long size = 0L;
                    for (StoredMessage m : folder.getMessages()) {
                        size += (long)m.getMimeMessage().getSize();
                    }
                    r.usage = size;
                    continue;
                }
                if ("MESSAGES".equals(r.name)) {
                    r.usage = folder.getMessageCount();
                    continue;
                }
                throw new IllegalStateException("Quota " + r.name + " not supported");
            }
        }
        catch (MessagingException ex) {
            throw new IllegalStateException("Can not update/verify quota " + quota, ex);
        }
    }

    @Override
    public void setQuota(Quota quota, String qualifiedRootPrefix) {
        for (Quota.Resource r : quota.resources) {
            if ("STORAGE".equals(r.name) || "MESSAGES".equals(r.name)) continue;
            throw new IllegalStateException("Quota " + r.name + " not supported");
        }
        Set<Quota> quotas = this.quotaMap.get(qualifiedRootPrefix + quota.quotaRoot);
        if (null == quotas) {
            quotas = new HashSet<Quota>();
            this.quotaMap.put(qualifiedRootPrefix + quota.quotaRoot, quotas);
        } else {
            quotas.clear();
        }
        quotas.add(quota);
    }

    private void addAllChildren(HierarchicalFolder mailbox, Collection<MailFolder> mailboxes) {
        Collection<HierarchicalFolder> children = mailbox.getChildren();
        for (HierarchicalFolder child : children) {
            mailboxes.add(child);
            this.addAllChildren(child, mailboxes);
        }
    }

    @Override
    public boolean isQuotaSupported() {
        return this.quotaSupported;
    }

    @Override
    public void setQuotaSupported(boolean pQuotaSupported) {
        this.quotaSupported = pQuotaSupported;
    }
}

