/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap;

import java.util.Collection;
import java.util.Optional;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WARestClient {
    private static final Logger LOG = LoggerFactory.getLogger(WARestClient.class);
    private final String anonymousUser;
    private final String anonymousKey;
    private final boolean useGZIPCompression;
    private SyncopeClient client;

    public WARestClient(String anonymousUser, String anonymousKey, boolean useGZIPCompression) {
        this.anonymousUser = anonymousUser;
        this.anonymousKey = anonymousKey;
        this.useGZIPCompression = useGZIPCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncopeClient getSyncopeClient() {
        WARestClient wARestClient = this;
        synchronized (wARestClient) {
            if (this.client == null) {
                WARestClient.getCore().ifPresent(core -> {
                    try {
                        this.client = new SyncopeClientFactoryBean().setAddress(core.getAddress()).setUseCompression(this.useGZIPCompression).create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey));
                    }
                    catch (Exception e) {
                        LOG.error("Could not init SyncopeClient", (Throwable)e);
                    }
                });
            }
            return this.client;
        }
    }

    private static Optional<NetworkService> getCore() {
        try {
            ApplicationContext context = ApplicationContextProvider.getApplicationContext();
            if (context == null) {
                return Optional.empty();
            }
            Collection serviceOpsList = context.getBeansOfType(ServiceOps.class).values();
            if (serviceOpsList.isEmpty()) {
                return Optional.empty();
            }
            ServiceOps serviceOps = (ServiceOps)serviceOpsList.iterator().next();
            return Optional.of(serviceOps.get(NetworkService.Type.CORE));
        }
        catch (KeymasterException e) {
            LOG.trace(e.getMessage());
            return Optional.empty();
        }
    }

    public static boolean isReady() {
        try {
            return WARestClient.getCore().isPresent();
        }
        catch (Exception e) {
            LOG.trace(e.getMessage());
            return false;
        }
    }
}

