/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.Optional;
import javax.sql.DataSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.rewrite.RewriteAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.logic.init.AuditAccessor;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.context.ApplicationContext;

public class AuditLoader
implements SyncopeCoreLoader {
    protected static final String ROOT_LOGGER = "ROOT";
    protected final AuditAccessor auditAccessor;
    protected final ApplicationContext ctx;

    public static void addAppenderToLoggerContext(LoggerContext ctx, AuditAppender auditAppender, LoggerConfig eventLogConf) {
        Appender targetAppender = ctx.getConfiguration().getAppender(auditAppender.getTargetAppenderName());
        if (targetAppender == null) {
            targetAppender = auditAppender.getTargetAppender();
        }
        targetAppender.start();
        ctx.getConfiguration().addAppender(targetAppender);
        Optional<RewriteAppender> rewriteAppender = auditAppender.getRewriteAppender();
        if (rewriteAppender.isPresent()) {
            rewriteAppender.get().start();
            eventLogConf.addAppender((Appender)rewriteAppender.get(), Level.DEBUG, null);
        } else {
            eventLogConf.addAppender(targetAppender, Level.DEBUG, null);
        }
    }

    public AuditLoader(AuditAccessor auditAccessor, ApplicationContext ctx) {
        this.auditAccessor = auditAccessor;
        this.ctx = ctx;
    }

    public int getOrder() {
        return 300;
    }

    public void load(String domain, DataSource datasource) {
        LoggerContext logCtx = (LoggerContext)LogManager.getContext((boolean)false);
        this.ctx.getBeansOfType(AuditAppender.class).values().forEach(auditAppender -> auditAppender.getEvents().stream().map(event -> AuditLoggerName.getAuditEventLoggerName((String)domain, (String)event.toAuditKey())).forEach(domainAuditLoggerName -> {
            LoggerConfig eventLogConf = logCtx.getConfiguration().getLoggerConfig(domainAuditLoggerName);
            boolean isRootLogConf = "".equals(eventLogConf.getName());
            if (isRootLogConf) {
                eventLogConf = new LoggerConfig(domainAuditLoggerName, null, false);
            }
            AuditLoader.addAppenderToLoggerContext(logCtx, auditAppender, eventLogConf);
            eventLogConf.setLevel(Level.DEBUG);
            if (isRootLogConf) {
                logCtx.getConfiguration().addLogger(domainAuditLoggerName, eventLogConf);
            }
        }));
        AuthContextUtils.callAsAdmin((String)domain, () -> {
            this.auditAccessor.synchronizeLoggingWithAudit(logCtx);
            return null;
        });
        logCtx.updateLoggers();
    }
}

