/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SchemaLogic
extends AbstractTransactionalLogic<SchemaTO> {
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final SchemaDataBinder binder;

    public SchemaLogic(PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, AnyTypeClassDAO anyTypeClassDAO, SchemaDataBinder binder) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.binder = binder;
    }

    protected boolean doesSchemaExist(SchemaType schemaType, String name) {
        boolean found;
        switch (schemaType) {
            case VIRTUAL: {
                found = this.virSchemaDAO.find(name) != null;
                break;
            }
            case DERIVED: {
                found = this.derSchemaDAO.find(name) != null;
                break;
            }
            case PLAIN: {
                found = this.plainSchemaDAO.find(name) != null;
                break;
            }
            default: {
                found = false;
            }
        }
        return found;
    }

    @PreAuthorize(value="hasRole('SCHEMA_CREATE')")
    public <T extends SchemaTO> T create(SchemaType schemaType, T schemaTO) {
        VirSchemaTO created;
        if (StringUtils.isBlank((CharSequence)schemaTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Schema key");
            throw sce;
        }
        if (this.doesSchemaExist(schemaType, schemaTO.getKey())) {
            throw new DuplicateException(schemaType + "/" + schemaTO.getKey());
        }
        switch (schemaType) {
            case VIRTUAL: {
                VirSchema virSchema = (VirSchema)this.virSchemaDAO.save((Schema)this.binder.create((VirSchemaTO)schemaTO));
                created = this.binder.getVirSchemaTO(virSchema.getKey());
                break;
            }
            case DERIVED: {
                DerSchema derSchema = (DerSchema)this.derSchemaDAO.save((Schema)this.binder.create((DerSchemaTO)schemaTO));
                created = this.binder.getDerSchemaTO(derSchema.getKey());
                break;
            }
            default: {
                PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.save((Schema)this.binder.create((PlainSchemaTO)schemaTO));
                created = this.binder.getPlainSchemaTO(plainSchema.getKey());
            }
        }
        return (T)created;
    }

    @PreAuthorize(value="hasRole('SCHEMA_DELETE')")
    public void delete(SchemaType schemaType, String schemaKey) {
        if (!this.doesSchemaExist(schemaType, schemaKey)) {
            throw new NotFoundException(schemaType + "/" + schemaKey);
        }
        switch (schemaType) {
            case VIRTUAL: {
                this.virSchemaDAO.delete(schemaKey);
                break;
            }
            case DERIVED: {
                this.derSchemaDAO.delete(schemaKey);
                break;
            }
            default: {
                this.plainSchemaDAO.delete(schemaKey);
            }
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public <T extends SchemaTO> List<T> search(SchemaType schemaType, List<String> anyTypeClasses, String keyword) {
        List result;
        ArrayList classes = new ArrayList(Optional.ofNullable(anyTypeClasses).map(List::size).orElse(0));
        if (anyTypeClasses != null) {
            anyTypeClasses.remove(AnyTypeKind.USER.name());
            anyTypeClasses.remove(AnyTypeKind.GROUP.name());
            anyTypeClasses.forEach(anyTypeClass -> {
                AnyTypeClass clazz = this.anyTypeClassDAO.find(anyTypeClass);
                if (clazz == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), anyTypeClass);
                } else {
                    classes.add(clazz);
                }
            });
        }
        switch (schemaType) {
            case VIRTUAL: {
                result = (classes.isEmpty() ? (keyword == null ? this.virSchemaDAO.findAll() : this.virSchemaDAO.findByKeyword(keyword)) : this.virSchemaDAO.findByAnyTypeClasses(classes)).stream().map(schema -> this.binder.getVirSchemaTO(schema.getKey())).collect(Collectors.toList());
                break;
            }
            case DERIVED: {
                result = (classes.isEmpty() ? (keyword == null ? this.derSchemaDAO.findAll() : this.derSchemaDAO.findByKeyword(keyword)) : this.derSchemaDAO.findByAnyTypeClasses(classes)).stream().map(schema -> this.binder.getDerSchemaTO(schema.getKey())).collect(Collectors.toList());
                break;
            }
            default: {
                result = (classes.isEmpty() ? (keyword == null ? this.plainSchemaDAO.findAll() : this.plainSchemaDAO.findByKeyword(keyword)) : this.plainSchemaDAO.findByAnyTypeClasses(classes)).stream().map(schema -> this.binder.getPlainSchemaTO(schema.getKey())).collect(Collectors.toList());
            }
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    public <T extends SchemaTO> T read(SchemaType schemaType, String schemaKey) {
        VirSchemaTO read;
        switch (schemaType) {
            case VIRTUAL: {
                read = this.binder.getVirSchemaTO(schemaKey);
                break;
            }
            case DERIVED: {
                read = this.binder.getDerSchemaTO(schemaKey);
                break;
            }
            default: {
                read = this.binder.getPlainSchemaTO(schemaKey);
            }
        }
        return (T)read;
    }

    @PreAuthorize(value="hasRole('SCHEMA_UPDATE')")
    public <T extends SchemaTO> void update(SchemaType schemaType, T schemaTO) {
        if (!this.doesSchemaExist(schemaType, schemaTO.getKey())) {
            throw new NotFoundException(schemaType + "/" + schemaTO.getKey());
        }
        switch (schemaType) {
            case VIRTUAL: {
                VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(schemaTO.getKey());
                if (virSchema == null) {
                    throw new NotFoundException("Virtual Schema '" + schemaTO.getKey() + "'");
                }
                this.virSchemaDAO.save((Schema)this.binder.update((VirSchemaTO)schemaTO, virSchema));
                break;
            }
            case DERIVED: {
                DerSchema derSchema = (DerSchema)this.derSchemaDAO.find(schemaTO.getKey());
                if (derSchema == null) {
                    throw new NotFoundException("Derived schema '" + schemaTO.getKey() + "'");
                }
                this.derSchemaDAO.save((Schema)this.binder.update((DerSchemaTO)schemaTO, derSchema));
                break;
            }
            default: {
                PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.find(schemaTO.getKey());
                if (plainSchema == null) {
                    throw new NotFoundException("Schema '" + schemaTO.getKey() + "'");
                }
                this.plainSchemaDAO.save((Schema)this.binder.update((PlainSchemaTO)schemaTO, plainSchema));
            }
        }
    }

    @Override
    protected SchemaTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SchemaTO)) continue;
                key = ((SchemaTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                PlainSchemaTO result = null;
                PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.find(key);
                if (plainSchema == null) {
                    DerSchema derSchema = (DerSchema)this.derSchemaDAO.find(key);
                    if (derSchema == null) {
                        VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(key);
                        if (virSchema != null) {
                            result = this.binder.getVirSchemaTO(key);
                        }
                    } else {
                        result = this.binder.getDerSchemaTO(key);
                    }
                } else {
                    result = this.binder.getPlainSchemaTO(key);
                }
                return result;
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

