/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.time.OffsetDateTime;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.rest.api.beans.RemediationQuery;
import org.apache.syncope.common.rest.api.service.RemediationService;
import org.apache.syncope.core.logic.RemediationLogic;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class RemediationServiceImpl
extends AbstractService
implements RemediationService {
    protected final RemediationLogic logic;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;

    public RemediationServiceImpl(RemediationLogic logic, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO) {
        this.logic = logic;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
    }

    public PagedResult<RemediationTO> list(RemediationQuery query) {
        Pair result = this.logic.list(query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public RemediationTO read(String key) {
        return this.logic.read(key);
    }

    public Response delete(String key) {
        this.logic.delete(key);
        return Response.noContent().build();
    }

    public Response remedy(String remediationKey, AnyCR anyCR) {
        ProvisioningResult created = this.logic.remedy(remediationKey, anyCR, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    private void check(String key, String anyKey) {
        UserDAO anyDAO;
        RemediationTO remediation = this.logic.read(key);
        switch (remediation.getAnyType()) {
            case "USER": {
                anyDAO = this.userDAO;
                break;
            }
            case "GROUP": {
                anyDAO = this.groupDAO;
                break;
            }
            default: {
                anyDAO = this.anyObjectDAO;
            }
        }
        OffsetDateTime etag = anyDAO.findLastChange(anyKey);
        if (etag == null) {
            throw new NotFoundException(remediation.getAnyType() + " for " + key);
        }
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
    }

    public Response remedy(String remediationKey, AnyUR anyUR) {
        this.check(remediationKey, anyUR.getKey());
        ProvisioningResult updated = this.logic.remedy(remediationKey, anyUR, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response remedy(String remediationKey, String anyKey) {
        this.check(remediationKey, anyKey);
        ProvisioningResult deleted = this.logic.remedy(remediationKey, anyKey, this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }
}

