/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.DefaultSamlIdPCasEventListener;
import org.apereo.cas.support.saml.idp.SamlIdPCasEventListener;
import org.apereo.cas.support.saml.idp.metadata.generator.FileSystemSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.FileSystemSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataResolver;
import org.apereo.cas.support.saml.idp.metadata.writer.DefaultSamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.idp.metadata.writer.SamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataHealthIndicator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceDefaultCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.ClasspathResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.FileSystemResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.GroovyResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.JsonResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.MetadataQueryProtocolMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.DefaultSamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlanConfigurer;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.NonInflatingSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdPMetadataController;
import org.apereo.cas.support.saml.web.idp.metadata.SamlRegisteredServiceCachedMetadataEndpoint;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostProfileHandlerEndpoint;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPErrorController;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SAMLIdentityProvider)
@AutoConfiguration
public class SamlIdPMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataConfiguration.class);

    @Configuration(value="SamlIdPMetadataInitializationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataInitializationConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPCasEventListener samlIdPCasEventListener(@Qualifier(value="samlIdPMetadataGenerator") SamlIdPMetadataGenerator samlIdPMetadataGenerator) {
            return new DefaultSamlIdPCasEventListener(samlIdPMetadataGenerator);
        }
    }

    @Configuration(value="SamlIdPMetadataContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataContextConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"samlIdPMetadataGeneratorConfigurationContext"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, @Qualifier(value="samlSelfSignedCertificateWriter") SamlIdPCertificateAndKeyWriter samlSelfSignedCertificateWriter, @Qualifier(value="samlIdPMetadataGeneratorCipherExecutor") CipherExecutor samlIdPMetadataGeneratorCipherExecutor, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="velocityEngineFactoryBean") VelocityEngine velocityEngineFactoryBean) throws Exception {
            return SamlIdPMetadataGeneratorConfigurationContext.builder().samlIdPMetadataLocator(samlIdPMetadataLocator).samlIdPCertificateAndKeyWriter(samlSelfSignedCertificateWriter).applicationContext(applicationContext).metadataCipherExecutor(samlIdPMetadataGeneratorCipherExecutor).casProperties(casProperties).openSamlConfigBean(openSamlConfigBean).velocityEngine(velocityEngineFactoryBean).build();
        }
    }

    @Configuration(value="SamlIdPMetadataResolverConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataResolverConfiguration {
        @ConditionalOnMissingBean(name={"defaultSamlRegisteredServiceCachingMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="chainingMetadataResolverCacheLoader") CacheLoader<SamlRegisteredServiceCacheKey, MetadataResolver> chainingMetadataResolverCacheLoader, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlRegisteredServiceDefaultCachingMetadataResolver(casProperties, chainingMetadataResolverCacheLoader, openSamlConfigBean);
        }
    }

    @Configuration(value="SamlIdPMetadataCacheConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataCacheConfiguration {
        @ConditionalOnMissingBean(name={"samlIdPMetadataCache"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache(CasConfigurationProperties casProperties) {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            return Caffeine.newBuilder().initialCapacity(10).maximumSize(100L).expireAfterAccess(Beans.newDuration((String)idp.getMetadata().getCore().getCacheExpiration())).build();
        }

        @ConditionalOnMissingBean(name={"chainingMetadataResolverCacheLoader"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CacheLoader<SamlRegisteredServiceCacheKey, MetadataResolver> chainingMetadataResolverCacheLoader(@Qualifier(value="samlRegisteredServiceMetadataResolvers") SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers, @Qualifier(value="httpClient") HttpClient httpClient, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlRegisteredServiceMetadataResolverCacheLoader(openSamlConfigBean, httpClient, samlRegisteredServiceMetadataResolvers);
        }
    }

    @Configuration(value="SamlIdPMetadataLocatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataLocatorConfiguration {
        @ConditionalOnMissingBean(name={"samlIdPMetadataLocator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataLocator samlIdPMetadataLocator(CasConfigurationProperties casProperties, @Qualifier(value="samlIdPMetadataCache") Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache) throws Exception {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            String location = SpringExpressionLanguageValueResolver.getInstance().resolve(idp.getMetadata().getFileSystem().getLocation());
            AbstractResource metadataLocation = ResourceUtils.getRawResourceFrom((String)location);
            return new FileSystemSamlIdPMetadataLocator((Resource)metadataLocation, samlIdPMetadataCache);
        }
    }

    @Configuration(value="SamlIdPMetadataGenerationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataGenerationConfiguration {
        @ConditionalOnMissingBean(name={"samlIdPMetadataGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataGenerator samlIdPMetadataGenerator(@Qualifier(value="samlIdPMetadataGeneratorConfigurationContext") SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext) throws Exception {
            return new FileSystemSamlIdPMetadataGenerator(samlIdPMetadataGeneratorConfigurationContext);
        }

        @ConditionalOnMissingBean(name={"samlSelfSignedCertificateWriter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPCertificateAndKeyWriter samlSelfSignedCertificateWriter(CasConfigurationProperties casProperties) throws Exception {
            URL url = new URL(casProperties.getServer().getPrefix());
            DefaultSamlIdPCertificateAndKeyWriter generator = new DefaultSamlIdPCertificateAndKeyWriter();
            generator.setHostname(url.getHost());
            generator.setUriSubjectAltNames(CollectionUtils.wrap((Object)url.getHost().concat("/idp/metadata")));
            return generator;
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPMetadataGeneratorCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor samlIdPMetadataGeneratorCipherExecutor() {
            return CipherExecutor.noOpOfStringToString();
        }
    }

    @Configuration(value="SamlIdPMetadataResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataResolutionConfiguration {
        @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataResolvers"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers(@Qualifier(value="httpClient") HttpClient httpClient, ObjectProvider<List<SamlRegisteredServiceMetadataResolutionPlanConfigurer>> configurersList, CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            DefaultSamlRegisteredServiceMetadataResolutionPlan plan = new DefaultSamlRegisteredServiceMetadataResolutionPlan();
            SamlIdPProperties samlIdp = casProperties.getAuthn().getSamlIdp();
            plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new MetadataQueryProtocolMetadataResolver(httpClient, samlIdp, openSamlConfigBean));
            plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new JsonResourceMetadataResolver(samlIdp, openSamlConfigBean));
            plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new FileSystemResourceMetadataResolver(samlIdp, openSamlConfigBean));
            plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new UrlResourceMetadataResolver(httpClient, samlIdp, openSamlConfigBean));
            plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new ClasspathResourceMetadataResolver(samlIdp, openSamlConfigBean));
            plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new GroovyResourceMetadataResolver(samlIdp, openSamlConfigBean));
            List configurers = Optional.ofNullable((List)configurersList.getIfAvailable()).orElseGet(ArrayList::new);
            configurers.forEach(c -> {
                LOGGER.trace("Configuring saml metadata resolution plan [{}]", (Object)c.getName());
                c.configureMetadataResolutionPlan((SamlRegisteredServiceMetadataResolutionPlan)plan);
            });
            return plan;
        }

        @Lazy
        @Bean(initMethod="initialize", destroyMethod="destroy")
        @DependsOn(value={"samlIdPMetadataGenerator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MetadataResolver casSamlIdPMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, @Qualifier(value="samlIdPMetadataGenerator") SamlIdPMetadataGenerator samlIdPMetadataGenerator, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) throws Exception {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            SamlIdPMetadataResolver resolver = new SamlIdPMetadataResolver(samlIdPMetadataLocator, samlIdPMetadataGenerator, openSamlConfigBean, casProperties);
            resolver.setFailFastInitialization(idp.getMetadata().getCore().isFailFast());
            resolver.setRequireValidMetadata(idp.getMetadata().getCore().isRequireValidMetadata());
            resolver.setId(idp.getCore().getEntityId());
            return resolver;
        }
    }

    @Configuration(value="SamlIdPMetadataEndpointConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPMetadataEndpointConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPErrorController samlIdPErrorController() {
            return new SamlIdPErrorController();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataController samlIdPMetadataController(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="samlIdPMetadataGenerator") SamlIdPMetadataGenerator samlIdPMetadataGenerator, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new SamlIdPMetadataController(samlIdPMetadataGenerator, samlIdPMetadataLocator, servicesManager, webApplicationServiceFactory);
        }

        @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataHealthIndicator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnEnabledHealthIndicator(value="samlRegisteredServiceMetadataHealthIndicator")
        public HealthIndicator samlRegisteredServiceMetadataHealthIndicator(@Qualifier(value="samlRegisteredServiceMetadataResolvers") SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new SamlRegisteredServiceMetadataHealthIndicator(samlRegisteredServiceMetadataResolvers, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public SamlRegisteredServiceCachedMetadataEndpoint samlRegisteredServiceCachedMetadataEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return new SamlRegisteredServiceCachedMetadataEndpoint(casProperties, defaultSamlRegisteredServiceCachingMetadataResolver, servicesManager, registeredServiceAccessStrategyEnforcer, openSamlConfigBean);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public SSOSamlIdPPostProfileHandlerEndpoint ssoSamlPostProfileHandlerEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<Response> samlProfileSamlResponseBuilder, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return new SSOSamlIdPPostProfileHandlerEndpoint(casProperties, servicesManager, authenticationSystemSupport, samlIdPServiceFactory, PrincipalFactoryUtils.newPrincipalFactory(), samlProfileSamlResponseBuilder, defaultSamlRegisteredServiceCachingMetadataResolver, (AbstractSaml20ObjectBuilder)new NonInflatingSaml20ObjectBuilder(openSamlConfigBean));
        }
    }
}

