/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.StringReplacePatchItem;
import org.apache.syncope.common.lib.to.TypeExtensionTO;

@Schema(allOf={AnyUR.class})
public class GroupUR
extends AnyUR {
    private static final long serialVersionUID = -460284378124440077L;
    private StringReplacePatchItem name;
    private StringReplacePatchItem userOwner;
    private StringReplacePatchItem groupOwner;
    private String udynMembershipCond;
    private final Map<String, String> adynMembershipConds = new HashMap<String, String>();
    private final List<TypeExtensionTO> typeExtensions = new ArrayList<TypeExtensionTO>();

    @Override
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    @Schema(name="_class", required=true, example="org.apache.syncope.common.lib.request.GroupUR")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public StringReplacePatchItem getName() {
        return this.name;
    }

    public void setName(StringReplacePatchItem name) {
        this.name = name;
    }

    public StringReplacePatchItem getUserOwner() {
        return this.userOwner;
    }

    public void setUserOwner(StringReplacePatchItem userOwner) {
        this.userOwner = userOwner;
    }

    public StringReplacePatchItem getGroupOwner() {
        return this.groupOwner;
    }

    public void setGroupOwner(StringReplacePatchItem groupOwner) {
        this.groupOwner = groupOwner;
    }

    public String getUDynMembershipCond() {
        return this.udynMembershipCond;
    }

    public void setUDynMembershipCond(String udynMembershipCond) {
        this.udynMembershipCond = udynMembershipCond;
    }

    public Map<String, String> getADynMembershipConds() {
        return this.adynMembershipConds;
    }

    @JsonIgnore
    public Optional<TypeExtensionTO> getTypeExtension(String anyType) {
        return this.typeExtensions.stream().filter(typeExtension -> anyType != null && anyType.equals(typeExtension.getAnyType())).findFirst();
    }

    @JacksonXmlElementWrapper(localName="typeExtensions")
    @JacksonXmlProperty(localName="typeExtension")
    public List<TypeExtensionTO> getTypeExtensions() {
        return this.typeExtensions;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.name == null && this.userOwner == null && this.groupOwner == null;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.name).append((Object)this.userOwner).append((Object)this.groupOwner).append((Object)this.udynMembershipCond).append(this.adynMembershipConds).append(this.typeExtensions).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupUR other = (GroupUR)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.name, (Object)other.name).append((Object)this.userOwner, (Object)other.userOwner).append((Object)this.groupOwner, (Object)other.groupOwner).append((Object)this.udynMembershipCond, (Object)other.udynMembershipCond).append(this.adynMembershipConds, other.adynMembershipConds).append(this.typeExtensions, other.typeExtensions).build();
    }

    public static class Builder
    extends AnyUR.Builder<GroupUR, Builder> {
        public Builder(String key) {
            super(key);
        }

        @Override
        protected GroupUR newInstance() {
            return new GroupUR();
        }

        public Builder name(StringReplacePatchItem name) {
            ((GroupUR)this.getInstance()).setName(name);
            return this;
        }

        public Builder userOwner(StringReplacePatchItem userOwner) {
            ((GroupUR)this.getInstance()).setUserOwner(userOwner);
            return this;
        }

        public Builder groupOwner(StringReplacePatchItem groupOwner) {
            ((GroupUR)this.getInstance()).setGroupOwner(groupOwner);
            return this;
        }

        public Builder udynMembershipCond(String udynMembershipCond) {
            ((GroupUR)this.getInstance()).setUDynMembershipCond(udynMembershipCond);
            return this;
        }

        public Builder adynMembershipCond(String type, String fiql) {
            ((GroupUR)this.getInstance()).getADynMembershipConds().put(type, fiql);
            return this;
        }

        public Builder adynMembershipConds(Map<String, String> conds) {
            ((GroupUR)this.getInstance()).getADynMembershipConds().putAll(conds);
            return this;
        }

        public Builder typeExtension(TypeExtensionTO typeExtension) {
            ((GroupUR)this.getInstance()).getTypeExtensions().add(typeExtension);
            return this;
        }

        public Builder typeExtensions(TypeExtensionTO ... typeExtensions) {
            ((GroupUR)this.getInstance()).getTypeExtensions().addAll(List.of(typeExtensions));
            return this;
        }

        public Builder typeExtensions(Collection<TypeExtensionTO> typeExtensions) {
            ((GroupUR)this.getInstance()).getTypeExtensions().addAll(typeExtensions);
            return this;
        }
    }
}

