/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.script.Script;
import org.identityconnectors.common.script.ScriptBuilder;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.exceptions.ConnectionBrokenException;
import org.identityconnectors.framework.common.exceptions.ConnectionFailedException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.exceptions.ConnectorSecurityException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.InvalidPasswordException;
import org.identityconnectors.framework.common.exceptions.OperationTimeoutException;
import org.identityconnectors.framework.common.exceptions.PasswordExpiredException;
import org.identityconnectors.framework.common.exceptions.PermissionDeniedException;
import org.identityconnectors.framework.common.exceptions.PreconditionFailedException;
import org.identityconnectors.framework.common.exceptions.PreconditionRequiredException;
import org.identityconnectors.framework.common.exceptions.RetryableException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.remote.RemoteWrappedException;
import org.identityconnectors.framework.impl.serializer.AbstractObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.EnumSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectDecoder;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

class CommonObjectHandlers {
    public static final List<ObjectTypeMapper> HANDLERS = new ArrayList<ObjectTypeMapper>();

    CommonObjectHandlers() {
    }

    static {
        HANDLERS.add(new ThrowableHandler<AlreadyExistsException>(AlreadyExistsException.class, "AlreadyExistsException"){

            @Override
            protected AlreadyExistsException createException(String message) {
                return new AlreadyExistsException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<ConfigurationException>(ConfigurationException.class, "ConfigurationException"){

            @Override
            protected ConfigurationException createException(String message) {
                return new ConfigurationException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<ConnectionBrokenException>(ConnectionBrokenException.class, "ConnectionBrokenException"){

            @Override
            protected ConnectionBrokenException createException(String message) {
                return new ConnectionBrokenException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<ConnectionFailedException>(ConnectionFailedException.class, "ConnectionFailedException"){

            @Override
            protected ConnectionFailedException createException(String message) {
                return new ConnectionFailedException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<ConnectorIOException>(ConnectorIOException.class, "ConnectorIOException"){

            @Override
            protected ConnectorIOException createException(String message) {
                return new ConnectorIOException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<PasswordExpiredException>(PasswordExpiredException.class, "PasswordExpiredException"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                Uid uid = (Uid)decoder.readObjectField("Uid", Uid.class, null);
                PasswordExpiredException ex = (PasswordExpiredException)super.deserialize(decoder);
                return ex.initUid(uid);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                super.serialize(object, encoder);
                PasswordExpiredException val = (PasswordExpiredException)object;
                encoder.writeObjectField("Uid", val.getUid(), true);
            }

            @Override
            protected PasswordExpiredException createException(String message) {
                return new PasswordExpiredException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<InvalidPasswordException>(InvalidPasswordException.class, "InvalidPasswordException"){

            @Override
            protected InvalidPasswordException createException(String message) {
                return new InvalidPasswordException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<UnknownUidException>(UnknownUidException.class, "UnknownUidException"){

            @Override
            protected UnknownUidException createException(String message) {
                return new UnknownUidException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<InvalidCredentialException>(InvalidCredentialException.class, "InvalidCredentialException"){

            @Override
            protected InvalidCredentialException createException(String message) {
                return new InvalidCredentialException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<PermissionDeniedException>(PermissionDeniedException.class, "PermissionDeniedException"){

            @Override
            protected PermissionDeniedException createException(String message) {
                return new PermissionDeniedException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<ConnectorSecurityException>(ConnectorSecurityException.class, "ConnectorSecurityException"){

            @Override
            protected ConnectorSecurityException createException(String message) {
                return new ConnectorSecurityException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<OperationTimeoutException>(OperationTimeoutException.class, "OperationTimeoutException"){

            @Override
            protected OperationTimeoutException createException(String message) {
                return new OperationTimeoutException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<InvalidAttributeValueException>(InvalidAttributeValueException.class, "InvalidAttributeValueException"){

            @Override
            protected InvalidAttributeValueException createException(String message) {
                return new InvalidAttributeValueException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<PreconditionFailedException>(PreconditionFailedException.class, "PreconditionFailedException"){

            @Override
            protected PreconditionFailedException createException(String message) {
                return new PreconditionFailedException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<PreconditionRequiredException>(PreconditionRequiredException.class, "PreconditionRequiredException"){

            @Override
            protected PreconditionRequiredException createException(String message) {
                return new PreconditionRequiredException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<RetryableException>(RetryableException.class, "RetryableException"){

            @Override
            protected RetryableException createException(String message) {
                return RetryableException.wrap((String)message, (Throwable)null);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)RemoteWrappedException.class, "RemoteWrappedException"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String throwableClass = decoder.readStringField("class", ConnectorException.class.getName());
                String message = decoder.readStringField("message", null);
                RemoteWrappedException cause = (RemoteWrappedException)((Object)decoder.readObjectField("RemoteWrappedException", RemoteWrappedException.class, null));
                String stackTrace = decoder.readStringField("stackTrace", null);
                return new RemoteWrappedException(throwableClass, message, cause, stackTrace);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                RemoteWrappedException val = (RemoteWrappedException)((Object)object);
                encoder.writeStringField("class", val.getExceptionClass());
                encoder.writeStringField("message", val.getMessage());
                encoder.writeObjectField("RemoteWrappedException", (Object)val.getCause(), true);
                encoder.writeStringField("stackTrace", val.readStackTrace());
            }
        });
        HANDLERS.add(new ThrowableHandler<ConnectorException>(ConnectorException.class, "ConnectorException"){

            @Override
            protected ConnectorException createException(String message) {
                return new ConnectorException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<IllegalArgumentException>(IllegalArgumentException.class, "IllegalArgumentException"){

            @Override
            protected IllegalArgumentException createException(String message) {
                return new IllegalArgumentException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<RuntimeException>(RuntimeException.class, "RuntimeException"){

            @Override
            protected RuntimeException createException(String message) {
                return new RuntimeException(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<Exception>(Exception.class, "Exception"){

            @Override
            protected Exception createException(String message) {
                return new Exception(message);
            }
        });
        HANDLERS.add(new ThrowableHandler<Throwable>(Throwable.class, "Throwable"){

            @Override
            protected Throwable createException(String message) {
                return new RuntimeException(message);
            }
        });
        HANDLERS.add(new AttributeHandler<Attribute>(Attribute.class, "Attribute"){

            @Override
            protected Attribute createAttribute(String name, List<Object> value) {
                return AttributeBuilder.build((String)name, value);
            }
        });
        HANDLERS.add(new EnumSerializationHandler((Class<? extends Enum<?>>)AttributeInfo.Flags.class, "AttributeInfoFlag"));
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)AttributeInfo.class, "AttributeInfo"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                AttributeInfoBuilder builder = new AttributeInfoBuilder(decoder.readStringField("name", null), decoder.readClassField("type", null));
                EnumSet<AttributeInfo.Flags> flags = EnumSet.noneOf(AttributeInfo.Flags.class);
                int count = decoder.getNumSubObjects();
                for (int i = 0; i < count; ++i) {
                    Object o = decoder.readObjectContents(i);
                    if (!(o instanceof AttributeInfo.Flags)) continue;
                    flags.add((AttributeInfo.Flags)o);
                }
                builder.setFlags(flags);
                builder.setNativeName(decoder.readStringField("nativeName", null));
                builder.setSubtype(decoder.readStringField("subtype", null));
                return builder.build();
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                AttributeInfo val = (AttributeInfo)object;
                encoder.writeStringField("name", val.getName());
                encoder.writeClassField("type", val.getType());
                Set flags = val.getFlags();
                for (AttributeInfo.Flags flag : flags) {
                    encoder.writeObjectContents(flag);
                }
                encoder.writeStringField("nativeName", val.getNativeName());
                encoder.writeStringField("subtype", val.getSubtype());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)ConnectorObject.class, "ConnectorObject"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                ObjectClass objectClass = (ObjectClass)decoder.readObjectField("ObjectClass", ObjectClass.class, null);
                Set atts = (Set)decoder.readObjectField("Attributes", Set.class, null);
                return new ConnectorObject(objectClass, atts);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                ConnectorObject val = (ConnectorObject)object;
                encoder.writeObjectField("ObjectClass", val.getObjectClass(), true);
                encoder.writeObjectField("Attributes", val.getAttributes(), true);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Name.class, "Name"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                return new Name(val);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Name val = (Name)object;
                encoder.writeStringContents(val.getNameValue());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)ObjectClass.class, "ObjectClass"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String type = decoder.readStringField("type", null);
                return new ObjectClass(type);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                ObjectClass val = (ObjectClass)object;
                encoder.writeStringField("type", val.getObjectClassValue());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)ObjectClassInfo.class, "ObjectClassInfo"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String type = decoder.readStringField("type", null);
                boolean container = decoder.readBooleanField("container", false);
                boolean auxiliary = decoder.readBooleanField("auxiliary", false);
                Set attrInfo = (Set)decoder.readObjectField("AttributeInfos", Set.class, null);
                return new ObjectClassInfo(type, attrInfo, container, auxiliary);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                ObjectClassInfo val = (ObjectClassInfo)object;
                encoder.writeStringField("type", val.getType());
                encoder.writeBooleanField("container", val.isContainer());
                encoder.writeBooleanField("auxiliary", val.isAuxiliary());
                encoder.writeObjectField("AttributeInfos", val.getAttributeInfo(), true);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Schema.class, "Schema"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                Set objectClasses = (Set)decoder.readObjectField("ObjectClassInfos", Set.class, null);
                HashMap<String, ObjectClassInfo> objectClassesByName = new HashMap<String, ObjectClassInfo>();
                for (ObjectClassInfo info : objectClasses) {
                    objectClassesByName.put(info.getType(), info);
                }
                Set operationOptions = (Set)decoder.readObjectField("OperationOptionInfos", Set.class, null);
                HashMap<String, OperationOptionInfo> optionsByName = new HashMap<String, OperationOptionInfo>();
                for (OperationOptionInfo info : operationOptions) {
                    optionsByName.put(info.getName(), info);
                }
                Map objectClassNamesByOperation = (Map)decoder.readObjectField("objectClassesByOperation", null, null);
                Map optionsNamesByOperation = (Map)decoder.readObjectField("optionsByOperation", null, null);
                HashMap objectClassesByOperation = new HashMap();
                for (Map.Entry entry : objectClassNamesByOperation.entrySet()) {
                    Set names = (Set)entry.getValue();
                    HashSet<ObjectClassInfo> infos = new HashSet<ObjectClassInfo>();
                    for (String name : names) {
                        ObjectClassInfo objectClass = (ObjectClassInfo)objectClassesByName.get(name);
                        if (objectClass == null) continue;
                        infos.add(objectClass);
                    }
                    objectClassesByOperation.put((Class)entry.getKey(), infos);
                }
                HashMap optionsByOperation = new HashMap();
                for (Map.Entry entry : optionsNamesByOperation.entrySet()) {
                    Set names = (Set)entry.getValue();
                    HashSet<OperationOptionInfo> infos = new HashSet<OperationOptionInfo>();
                    for (String name : names) {
                        OperationOptionInfo info = (OperationOptionInfo)optionsByName.get(name);
                        if (info == null) continue;
                        infos.add(info);
                    }
                    optionsByOperation.put((Class)entry.getKey(), infos);
                }
                return new Schema(objectClasses, operationOptions, objectClassesByOperation, optionsByOperation);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                HashSet<String> names;
                Set value;
                Schema val = (Schema)object;
                encoder.writeObjectField("ObjectClassInfos", val.getObjectClassInfo(), true);
                encoder.writeObjectField("OperationOptionInfos", val.getOperationOptionInfo(), true);
                HashMap objectClassNamesByOperation = new HashMap();
                HashMap optionNamesByOperation = new HashMap();
                for (Map.Entry entry : val.getSupportedObjectClassesByOperation().entrySet()) {
                    value = (Set)entry.getValue();
                    names = new HashSet<String>();
                    for (ObjectClassInfo info : value) {
                        names.add(info.getType());
                    }
                    objectClassNamesByOperation.put((Class)entry.getKey(), names);
                }
                for (Map.Entry entry : val.getSupportedOptionsByOperation().entrySet()) {
                    value = (Set)entry.getValue();
                    names = new HashSet();
                    for (ObjectClassInfo info : value) {
                        names.add(info.getName());
                    }
                    optionNamesByOperation.put((Class)entry.getKey(), names);
                }
                encoder.writeObjectField("objectClassesByOperation", objectClassNamesByOperation, false);
                encoder.writeObjectField("optionsByOperation", optionNamesByOperation, false);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Uid.class, "Uid"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringField("uid", null);
                String revision = decoder.readStringField("revision", null);
                Name nameHint = (Name)decoder.readObjectField("nameHint", Name.class, null);
                if (null == revision && null == nameHint) {
                    return new Uid(val);
                }
                if (null == revision && null != nameHint) {
                    return new Uid(val, nameHint);
                }
                return new Uid(val, revision);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Uid val = (Uid)object;
                encoder.writeStringField("uid", val.getUidValue());
                encoder.writeStringField("revision", val.getRevision());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Script.class, "Script"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                ScriptBuilder builder = new ScriptBuilder();
                builder.setScriptLanguage(decoder.readStringField("scriptLanguage", null));
                builder.setScriptText((String)decoder.readObjectField("scriptText", String.class, null));
                return builder.build();
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Script val = (Script)object;
                encoder.writeStringField("scriptLanguage", val.getScriptLanguage());
                encoder.writeObjectField("scriptText", val.getScriptText(), true);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)ScriptContext.class, "ScriptContext"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String scriptLanguage = decoder.readStringField("scriptLanguage", null);
                Map arguments = (Map)decoder.readObjectField("scriptArguments", null, null);
                String scriptText = (String)decoder.readObjectField("scriptText", String.class, null);
                return new ScriptContext(scriptLanguage, scriptText, arguments);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                ScriptContext val = (ScriptContext)object;
                encoder.writeStringField("scriptLanguage", val.getScriptLanguage());
                encoder.writeObjectField("scriptArguments", val.getScriptArguments(), false);
                encoder.writeObjectField("scriptText", val.getScriptText(), true);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)OperationOptions.class, "OperationOptions"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                Map options = (Map)decoder.readObjectField("options", null, null);
                return new OperationOptions(options);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                OperationOptions val = (OperationOptions)object;
                encoder.writeObjectField("options", val.getOptions(), false);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)SearchResult.class, "SearchResult"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                return new SearchResult(decoder.readStringField("pagedResultsCookie", null), decoder.readIntField("remainingPagedResults", -1));
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                SearchResult val = (SearchResult)object;
                encoder.writeStringField("pagedResultsCookie", val.getPagedResultsCookie());
                encoder.writeIntField("remainingPagedResults", val.getRemainingPagedResults());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)SortKey.class, "SortKey"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                return new SortKey(decoder.readStringField("field", null), decoder.readBooleanField("isAscending", true));
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                SortKey val = (SortKey)object;
                encoder.writeStringField("field", val.getField());
                encoder.writeBooleanField("isAscending", val.isAscendingOrder());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)OperationOptionInfo.class, "OperationOptionInfo"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String name = decoder.readStringField("name", null);
                Class<?> type = decoder.readClassField("type", Class.class);
                return new OperationOptionInfo(name, type);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                OperationOptionInfo val = (OperationOptionInfo)object;
                encoder.writeStringField("name", val.getName());
                encoder.writeClassField("type", val.getType());
            }
        });
        HANDLERS.add(new EnumSerializationHandler((Class<? extends Enum<?>>)SyncDeltaType.class, "SyncDeltaType"));
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)SyncToken.class, "SyncToken"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                Object value = decoder.readObjectField("value", null, null);
                return new SyncToken(value);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                SyncToken val = (SyncToken)object;
                encoder.writeObjectField("value", val.getValue(), false);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)SyncDelta.class, "SyncDelta"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                SyncDeltaBuilder builder = new SyncDeltaBuilder();
                builder.setDeltaType((SyncDeltaType)decoder.readObjectField("SyncDeltaType", SyncDeltaType.class, null));
                builder.setToken((SyncToken)decoder.readObjectField("SyncToken", SyncToken.class, null));
                builder.setPreviousUid((Uid)decoder.readObjectField("PreviousUid", Uid.class, null));
                builder.setObjectClass((ObjectClass)decoder.readObjectField("ObjectClass", ObjectClass.class, null));
                builder.setUid((Uid)decoder.readObjectField("Uid", Uid.class, null));
                builder.setObject((ConnectorObject)decoder.readObjectField("ConnectorObject", ConnectorObject.class, null));
                return builder.build();
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                SyncDelta val = (SyncDelta)object;
                encoder.writeObjectField("SyncDeltaType", val.getDeltaType(), true);
                encoder.writeObjectField("SyncToken", val.getToken(), true);
                encoder.writeObjectField("PreviousUid", val.getPreviousUid(), true);
                encoder.writeObjectField("ObjectClass", val.getObjectClass(), true);
                encoder.writeObjectField("Uid", val.getUid(), true);
                encoder.writeObjectField("ConnectorObject", val.getObject(), true);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)AttributeDelta.class, "AttributeDelta"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                AttributeDeltaBuilder builder = new AttributeDeltaBuilder();
                builder.setName((String)decoder.readObjectField("Name", String.class, null));
                List addList = (List)decoder.readObjectField("ValuesToAdd", List.class, null);
                List removeList = (List)decoder.readObjectField("ValuesToRemove", List.class, null);
                List replaceList = (List)decoder.readObjectField("ValuesToReplace", List.class, null);
                if (addList != null || removeList != null) {
                    builder.addValueToAdd((Collection)addList);
                    builder.addValueToRemove((Collection)removeList);
                } else {
                    builder.addValueToReplace((Collection)replaceList);
                }
                return builder.build();
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                AttributeDelta val = (AttributeDelta)object;
                encoder.writeObjectField("Name", val.getName(), true);
                encoder.writeObjectField("ValuesToAdd", val.getValuesToAdd(), true);
                encoder.writeObjectField("ValuesToRemove", val.getValuesToRemove(), true);
                encoder.writeObjectField("ValuesToReplace", val.getValuesToReplace(), true);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)QualifiedUid.class, "QualifiedUid"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                ObjectClass objectClass = (ObjectClass)decoder.readObjectField("ObjectClass", ObjectClass.class, null);
                Uid uid = (Uid)decoder.readObjectField("Uid", Uid.class, null);
                return new QualifiedUid(objectClass, uid);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                QualifiedUid val = (QualifiedUid)object;
                encoder.writeObjectField("ObjectClass", val.getObjectClass(), true);
                encoder.writeObjectField("Uid", val.getUid(), true);
            }
        });
    }

    private static abstract class ThrowableHandler<T extends Throwable>
    extends AbstractObjectSerializationHandler {
        protected ThrowableHandler(Class<T> clazz, String typeName) {
            super(clazz, typeName);
        }

        @Override
        public Object deserialize(ObjectDecoder decoder) {
            String message = decoder.readStringField("message", null);
            return this.createException(message);
        }

        @Override
        public void serialize(Object object, ObjectEncoder encoder) {
            Throwable val = (Throwable)object;
            encoder.writeStringField("message", val.getMessage());
        }

        @Override
        public boolean isMatchSubclasses() {
            return true;
        }

        protected abstract T createException(String var1);
    }

    private static abstract class AttributeHandler<T extends Attribute>
    extends AbstractObjectSerializationHandler {
        protected AttributeHandler(Class<T> clazz, String typeName) {
            super(clazz, typeName);
        }

        @Override
        public final Object deserialize(ObjectDecoder decoder) {
            String name = decoder.readStringField("name", null);
            List value = (List)decoder.readObjectField("Values", List.class, null);
            return this.createAttribute(name, value);
        }

        @Override
        public final void serialize(Object object, ObjectEncoder encoder) {
            Attribute val = (Attribute)object;
            encoder.writeStringField("name", val.getName());
            encoder.writeObjectField("Values", val.getValue(), true);
        }

        protected abstract T createAttribute(String var1, List<Object> var2);
    }
}

