/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.rest.AMSessionDeserializer;
import org.apache.syncope.client.console.rest.AMSessionRestClient;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.AMSession;

public final class WASessionRestClient
extends AMSessionRestClient {
    private static final long serialVersionUID = 22118820292494L;
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new SimpleModule().addDeserializer(AMSession.class, (JsonDeserializer)new AMSessionDeserializer()))).build();

    public WASessionRestClient(List<NetworkService> instances) {
        super(instances);
    }

    @Override
    protected String getActuatorEndpoint() {
        return ((NetworkService)this.instances.get(0)).getAddress() + "actuator/ssoSessions";
    }

    @Override
    public List<AMSession> list() {
        try {
            Response response = WebClient.create((String)this.getActuatorEndpoint(), (String)SyncopeWebApplication.get().getAnonymousUser(), (String)SyncopeWebApplication.get().getAnonymousKey(), null).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                JsonNode node = MAPPER.readTree((InputStream)response.getEntity());
                if (node.has("activeSsoSessions")) {
                    return (List)MAPPER.readValue(MAPPER.treeAsTokens((TreeNode)node.get("activeSsoSessions")), (TypeReference)new TypeReference<List<AMSession>>(){});
                }
            } else {
                LOG.error("Unexpected response for SSO Sessions from {}: {}", (Object)this.getActuatorEndpoint(), (Object)response.getStatus());
            }
        }
        catch (Exception e) {
            LOG.error("Could not fetch SSO Sessions from {}", (Object)this.getActuatorEndpoint(), (Object)e);
        }
        return List.of();
    }
}

