/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.databind.json.JsonMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.OIDCJWKSRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDC
extends Panel {
    private static final long serialVersionUID = 12898029694947L;
    private static final Logger LOG = LoggerFactory.getLogger(OIDC.class);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private final BaseModal<String> viewModal = new BaseModal<String>("viewModal"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(true);
        }
    };
    private final AjaxLink<Void> view;
    private final AjaxLink<Void> generate;
    private final AjaxLink<Void> delete;

    public OIDC(String id, String waPrefix, final PageReference pageRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.viewModal});
        this.viewModal.size(Modal.Size.Extra_large);
        this.viewModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> this.viewModal.show(false));
        final WebMarkupContainer container = new WebMarkupContainer("container");
        this.add(new Component[]{container.setOutputMarkupId(true)});
        final AtomicReference<OIDCJWKSTO> oidcjwksto = OIDCJWKSRestClient.get();
        this.view = new AjaxLink<Void>("view"){
            private static final long serialVersionUID = 6250423506463465679L;

            public void onClick(AjaxRequestTarget target) {
                String pretty;
                try {
                    pretty = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MAPPER.readTree(((OIDCJWKSTO)oidcjwksto.get()).getJson()));
                }
                catch (IOException e) {
                    LOG.error("Could not pretty-print", (Throwable)e);
                    pretty = ((OIDCJWKSTO)oidcjwksto.get()).getJson();
                }
                OIDC.this.viewModal.header((IModel)Model.of((Serializable)((Object)"JSON Web Key Sets")));
                target.add(new Component[]{OIDC.this.viewModal.setContent((ModalPanel)new JsonEditorPanel(OIDC.this.viewModal, (IModel)Model.of((Serializable)((Object)pretty)), true, pageRef))});
                OIDC.this.viewModal.show(true);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (oidcjwksto.get() == null) {
                    tag.put("class", (CharSequence)"btn btn-app disabled");
                }
            }
        };
        this.view.setEnabled(oidcjwksto.get() != null);
        container.add(new Component[]{this.view.setOutputMarkupId(true)});
        MetaDataRoleAuthorizationStrategy.authorize(this.view, (Action)ENABLE, (String)"OIDC_JWKS_READ");
        this.generate = new AjaxLink<Void>("generate"){
            private static final long serialVersionUID = 6250423506463465679L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    oidcjwksto.set(OIDCJWKSRestClient.generate());
                    OIDC.this.generate.setEnabled(false);
                    OIDC.this.view.setEnabled(true);
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    target.add(new Component[]{container});
                }
                catch (Exception e) {
                    LOG.error("While generating OIDC JWKS", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (oidcjwksto.get() != null) {
                    tag.put("class", (CharSequence)"btn btn-app disabled");
                }
            }
        };
        this.generate.setEnabled(oidcjwksto.get() == null);
        container.add(new Component[]{this.generate.setOutputMarkupId(true)});
        MetaDataRoleAuthorizationStrategy.authorize(this.generate, (Action)ENABLE, (String)"OIDC_JWKS_GENERATE");
        this.delete = new AjaxLink<Void>("delete"){
            private static final long serialVersionUID = 6250423506463465679L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    OIDCJWKSRestClient.delete();
                    oidcjwksto.set(null);
                    OIDC.this.generate.setEnabled(true);
                    OIDC.this.view.setEnabled(false);
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    target.add(new Component[]{container});
                }
                catch (Exception e) {
                    LOG.error("While deleting OIDC JWKS", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (oidcjwksto.get() == null) {
                    tag.put("class", (CharSequence)"btn btn-app disabled");
                }
            }
        };
        this.delete.setEnabled(oidcjwksto.get() != null);
        container.add(new Component[]{this.delete.setOutputMarkupId(true)});
        MetaDataRoleAuthorizationStrategy.authorize(this.delete, (Action)ENABLE, (String)"OIDC_JWKS_DELETE");
        String wellKnownURI = waPrefix + "/oidc/.well-known/openid-configuration";
        container.add(new Component[]{new ExternalLink("wellKnownURI", wellKnownURI, wellKnownURI)});
    }
}

