/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.api.dao;

import java.util.List;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AuditConf;

public interface AuditConfDAO extends DAO<AuditConf> {

    String AUDIT_ENTRY_TABLE = "AuditEntry";

    String AUDIT_ENTRY_MESSAGE_COLUMN = "MESSAGE";

    AuditConf find(String key);

    List<AuditConf> findAll();

    AuditConf save(AuditConf auditConf);

    void delete(AuditConf auditConf);

    int countEntries(
            String entityKey,
            AuditElements.EventCategoryType type,
            String category,
            String subcategory,
            List<String> events,
            AuditElements.Result result);

    List<AuditEntry> searchEntries(
            String entityKey,
            int page,
            int itemsPerPage,
            AuditElements.EventCategoryType type,
            String category,
            String subcategory,
            List<String> events,
            AuditElements.Result result,
            List<OrderByClause> orderBy);
}
