/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PullMatch;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PullCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(readOnly=true)
@Component
public class InboundMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(InboundMatcher.class);
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private VirAttrHandler virAttrHandler;
    @Autowired
    private IntAttrNameParser intAttrNameParser;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    public Optional<PullMatch> match(AnyType anyType, String nameValue, ExternalResource resource, Connector connector) {
        Optional provision = resource.getProvision(anyType);
        if (!provision.isPresent()) {
            return Optional.empty();
        }
        Stream<MappingItem> mapItems = Stream.concat(((Provision)provision.get()).getMapping().getItems().stream(), this.virSchemaDAO.findByProvision((Provision)provision.get()).stream().map(VirSchema::asLinkingMappingItem));
        final ArrayList found = new ArrayList();
        Name nameAttr = new Name(nameValue);
        connector.search(((Provision)provision.get()).getObjectClass(), ((Provision)provision.get()).isIgnoreCaseMatch() ? FilterBuilder.equalsIgnoreCase((Attribute)nameAttr) : FilterBuilder.equalTo((Attribute)nameAttr), new SearchResultsHandler(){

            public void handleResult(SearchResult result) {
            }

            public boolean handle(ConnectorObject connectorObject) {
                return found.add(connectorObject);
            }
        }, MappingUtils.buildOperationOptions(mapItems, new String[0]));
        Optional<PullMatch> result = Optional.empty();
        if (found.isEmpty()) {
            LOG.debug("No {} found on {} with {} {}", new Object[]{((Provision)provision.get()).getObjectClass(), resource, Name.NAME, nameValue});
        } else {
            if (found.size() > 1) {
                LOG.warn("More than one {} found on {} with {} {} - taking first only", new Object[]{((Provision)provision.get()).getObjectClass(), resource, Name.NAME, nameValue});
            }
            ConnectorObject connObj = (ConnectorObject)found.iterator().next();
            try {
                List<PullMatch> matches = this.match(new SyncDeltaBuilder().setToken(new SyncToken((Object)"")).setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setObject(connObj).build(), (Provision)provision.get());
                if (matches.isEmpty()) {
                    LOG.debug("No matching {} found for {}, aborting", (Object)anyType.getKind(), (Object)connObj);
                } else {
                    if (matches.size() > 1) {
                        LOG.warn("More than one {} found {} - taking first only", (Object)anyType.getKind(), matches);
                    }
                    if ((result = matches.stream().filter(match -> match.getAny() != null).findFirst()).isPresent()) {
                        this.virAttrHandler.setValues(result.get().getAny(), connObj);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    public List<PullMatch> matchByConnObjectKeyValue(Item connObjectKeyItem, String connObjectKeyValue, Provision provision) {
        return this.matchByConnObjectKeyValue(connObjectKeyItem, connObjectKeyValue, provision.getAnyType().getKind(), provision.isIgnoreCaseMatch(), provision.getResource());
    }

    public List<PullMatch> matchByConnObjectKeyValue(Item connObjectKeyItem, String connObjectKeyValue, AnyTypeKind anyTypeKind, boolean ignoreCaseMatch, ExternalResource resource) {
        IntAttrName intAttrName;
        String finalConnObjectKeyValue = connObjectKeyValue;
        for (ItemTransformer transformer : MappingUtils.getItemTransformers(connObjectKeyItem)) {
            List output = transformer.beforePull(connObjectKeyItem, null, Collections.singletonList(finalConnObjectKeyValue));
            if (CollectionUtils.isEmpty((Collection)output)) continue;
            finalConnObjectKeyValue = output.get(0).toString();
        }
        List<PullMatch> noMatchResult = Collections.singletonList(PullCorrelationRule.NO_MATCH);
        try {
            intAttrName = this.intAttrNameParser.parse(connObjectKeyItem.getIntAttrName(), anyTypeKind);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)connObjectKeyItem.getIntAttrName(), (Object)e);
            return noMatchResult;
        }
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyTypeKind);
        ArrayList anys = new ArrayList();
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "key": {
                    Optional.ofNullable(anyUtils.dao().find(finalConnObjectKeyValue)).ifPresent(anys::add);
                    break;
                }
                case "username": {
                    if (anyTypeKind == AnyTypeKind.USER && ignoreCaseMatch) {
                        AnyCond cond = new AnyCond(AttrCond.Type.IEQ);
                        cond.setSchema("username");
                        cond.setExpression(finalConnObjectKeyValue);
                        anys.addAll(this.searchDAO.search(SearchCond.getLeaf((AbstractSearchCond)cond), AnyTypeKind.USER));
                        break;
                    }
                    Optional.ofNullable(this.userDAO.findByUsername(finalConnObjectKeyValue)).ifPresent(anys::add);
                    break;
                }
                case "name": {
                    AnyCond cond;
                    if (anyTypeKind == AnyTypeKind.GROUP && ignoreCaseMatch) {
                        cond = new AnyCond(AttrCond.Type.IEQ);
                        cond.setSchema("name");
                        cond.setExpression(finalConnObjectKeyValue);
                        anys.addAll(this.searchDAO.search(SearchCond.getLeaf((AbstractSearchCond)cond), AnyTypeKind.GROUP));
                    } else {
                        Optional.ofNullable(this.groupDAO.findByName(finalConnObjectKeyValue)).ifPresent(anys::add);
                    }
                    if (anyTypeKind == AnyTypeKind.ANY_OBJECT && ignoreCaseMatch) {
                        cond = new AnyCond(AttrCond.Type.IEQ);
                        cond.setSchema("name");
                        cond.setExpression(finalConnObjectKeyValue);
                        anys.addAll(this.searchDAO.search(SearchCond.getLeaf((AbstractSearchCond)cond), AnyTypeKind.ANY_OBJECT));
                        break;
                    }
                    Optional.ofNullable(this.anyObjectDAO.findByName(finalConnObjectKeyValue)).ifPresent(anys::add);
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttrValue value = intAttrName.getSchema().isUniqueConstraint() ? anyUtils.newPlainAttrUniqueValue() : anyUtils.newPlainAttrValue();
                    try {
                        value.parseValue((PlainSchema)intAttrName.getSchema(), finalConnObjectKeyValue);
                    }
                    catch (ParsingValidationException e) {
                        LOG.error("While parsing provided {} {}", new Object[]{Uid.NAME, value, e});
                        value.setStringValue(finalConnObjectKeyValue);
                    }
                    if (intAttrName.getSchema().isUniqueConstraint()) {
                        anyUtils.dao().findByPlainAttrUniqueValue((PlainSchema)intAttrName.getSchema(), (PlainAttrUniqueValue)value, ignoreCaseMatch).ifPresent(anys::add);
                        break;
                    }
                    anys.addAll(anyUtils.dao().findByPlainAttrValue((PlainSchema)intAttrName.getSchema(), value, ignoreCaseMatch));
                    break;
                }
                case DERIVED: {
                    anys.addAll(anyUtils.dao().findByDerAttrValue((DerSchema)intAttrName.getSchema(), finalConnObjectKeyValue, ignoreCaseMatch));
                    break;
                }
            }
        }
        List result = anys.stream().map(any -> new PullMatch(MatchType.ANY, (Entity)any)).collect(Collectors.toList());
        if (resource != null) {
            this.userDAO.findLinkedAccount(resource, finalConnObjectKeyValue).map(account -> new PullMatch(MatchType.LINKED_ACCOUNT, (Entity)account)).ifPresent(result::add);
        }
        return result.isEmpty() ? noMatchResult : result;
    }

    private List<PullMatch> matchByCorrelationRule(SyncDelta syncDelta, Provision provision, PullCorrelationRule rule, AnyTypeKind type) {
        ArrayList<PullMatch> result = new ArrayList<PullMatch>();
        result.addAll(this.searchDAO.search(rule.getSearchCond(syncDelta, provision), type).stream().map(any -> rule.matching(any, syncDelta, provision)).collect(Collectors.toList()));
        if (result.isEmpty()) {
            rule.unmatching(syncDelta, provision).ifPresent(result::add);
        }
        return result;
    }

    public List<PullMatch> match(SyncDelta syncDelta, Provision provision) {
        Optional correlationRule = provision.getResource().getPullPolicy() == null ? Optional.empty() : provision.getResource().getPullPolicy().getCorrelationRule(provision.getAnyType());
        Optional rule = Optional.empty();
        if (correlationRule.isPresent()) {
            try {
                rule = ImplementationManager.buildPullCorrelationRule((Implementation)((PullCorrelationRuleEntity)correlationRule.get()).getImplementation());
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)((PullCorrelationRuleEntity)correlationRule.get()).getImplementation(), (Object)e);
            }
        }
        List<Object> result = Collections.emptyList();
        try {
            if (rule.isPresent()) {
                result = this.matchByCorrelationRule(syncDelta, provision, (PullCorrelationRule)rule.get(), provision.getAnyType().getKind());
            } else {
                String connObjectKeyValue = null;
                Optional<? extends MappingItem> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
                if (connObjectKeyItem.isPresent()) {
                    Attribute connObjectKeyAttr = syncDelta.getObject().getAttributeByName(((Item)connObjectKeyItem.get()).getExtAttrName());
                    if (connObjectKeyAttr != null) {
                        connObjectKeyValue = AttributeUtil.getStringValue((Attribute)connObjectKeyAttr);
                    }
                    if (connObjectKeyValue == null) {
                        connObjectKeyValue = syncDelta.getUid().getUidValue();
                    }
                }
                result = connObjectKeyValue == null ? Collections.singletonList(PullCorrelationRule.NO_MATCH) : this.matchByConnObjectKeyValue((Item)connObjectKeyItem.get(), connObjectKeyValue, provision);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{syncDelta, provision.getAnyType(), e});
        }
        if (result.size() == 1 && ((PullMatch)result.get(0)).getMatchTarget() == MatchType.ANY) {
            this.virAttrHandler.setValues(((PullMatch)result.get(0)).getAny(), syncDelta.getObject());
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<Realm> match(SyncDelta syncDelta, OrgUnit orgUnit) {
        Object connObjectKeyAttr;
        String connObjectKey = null;
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent() && (connObjectKeyAttr = syncDelta.getObject().getAttributeByName(((Item)connObjectKeyItem.get()).getExtAttrName())) != null) {
            connObjectKey = AttributeUtil.getStringValue((Attribute)connObjectKeyAttr);
        }
        if (connObjectKey == null) {
            return Collections.emptyList();
        }
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)connObjectKeyItem.get())) {
            List output = transformer.beforePull((Item)connObjectKeyItem.get(), null, Collections.singletonList(connObjectKey));
            if (CollectionUtils.isEmpty((Collection)output)) continue;
            connObjectKey = output.get(0).toString();
        }
        ArrayList<Realm> result = new ArrayList<Realm>();
        switch (((Item)connObjectKeyItem.get()).getIntAttrName()) {
            case "key": {
                Realm realm = this.realmDAO.find(connObjectKey);
                if (realm == null) break;
                result.add(realm);
                break;
            }
            case "name": {
                if (orgUnit.isIgnoreCaseMatch()) {
                    String realmName = connObjectKey;
                    result.addAll(this.realmDAO.findAll().stream().filter(r -> r.getName().equalsIgnoreCase(realmName)).collect(Collectors.toList()));
                    break;
                }
                result.addAll(this.realmDAO.findByName(connObjectKey).stream().collect(Collectors.toList()));
                break;
            }
            case "fullpath": {
                Realm realm = this.realmDAO.findByFullPath(connObjectKey);
                if (realm == null) break;
                result.add(realm);
                break;
            }
        }
        return result;
    }
}

