/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PagedConnObjectTOResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.syncope.common.rest.api.service.ResourceService;
import org.apache.syncope.core.logic.ResourceLogic;
import org.apache.syncope.core.persistence.api.search.FilterVisitor;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceServiceImpl
extends AbstractServiceImpl
implements ResourceService {
    @Autowired
    private ResourceLogic logic;

    public Response create(ResourceTO resourceTO) {
        ResourceTO created = this.logic.create(resourceTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void update(ResourceTO resourceTO) {
        this.logic.update(resourceTO);
    }

    public void setLatestSyncToken(String key, String anyTypeKey) {
        this.logic.setLatestSyncToken(key, anyTypeKey);
    }

    public void removeSyncToken(String key, String anyTypeKey) {
        this.logic.removeSyncToken(key, anyTypeKey);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public ResourceTO read(String key) {
        return this.logic.read(key);
    }

    public List<ResourceTO> list() {
        return this.logic.list();
    }

    public Response getConnObjectKeyValue(String key, String anyTypeKey, String anyKey) {
        String connObjectKeyValue = this.logic.getConnObjectKeyValue(key, anyTypeKey, anyKey);
        return Response.noContent().header("X-Syncope-ConnObject-Key", (Object)connObjectKeyValue).build();
    }

    public ConnObjectTO readConnObject(String key, String anyTypeKey, String value) {
        return SyncopeConstants.UUID_PATTERN.matcher(value).matches() ? this.logic.readConnObjectByAnyKey(key, anyTypeKey, value) : this.logic.readConnObjectByConnObjectKeyValue(key, anyTypeKey, value);
    }

    public PagedConnObjectTOResult searchConnObjects(String key, String anyTypeKey, ConnObjectTOQuery query) {
        Filter filter = null;
        HashSet moreAttrsToGet = new HashSet();
        if (query.getMoreAttrsToGet() != null) {
            moreAttrsToGet.addAll(query.getMoreAttrsToGet());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getFiql())) {
            try {
                FilterVisitor visitor = new FilterVisitor();
                SearchCondition sc = this.searchContext.getCondition(query.getFiql(), SearchBean.class);
                sc.accept((SearchConditionVisitor)visitor);
                filter = visitor.getQuery();
                moreAttrsToGet.addAll(visitor.getAttrs());
            }
            catch (Exception e) {
                LOG.error("Invalid FIQL expression: {}", (Object)query.getFiql(), (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
                sce.getElements().add(query.getFiql());
                sce.getElements().add(ExceptionUtils.getRootCauseMessage((Throwable)e));
                throw sce;
            }
        }
        Pair list = this.logic.searchConnObjects(filter, moreAttrsToGet, key, anyTypeKey, query.getSize().intValue(), query.getPagedResultsCookie(), this.getOrderByClauses(query.getOrderBy()));
        PagedConnObjectTOResult result = new PagedConnObjectTOResult();
        if (list.getLeft() != null) {
            result.setAllResultsReturned(((SearchResult)list.getLeft()).isAllResultsReturned());
            result.setPagedResultsCookie(((SearchResult)list.getLeft()).getPagedResultsCookie());
            result.setRemainingPagedResults(((SearchResult)list.getLeft()).getRemainingPagedResults());
        }
        result.getResult().addAll((Collection)list.getRight());
        UriBuilder builder = this.uriInfo.getAbsolutePathBuilder();
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        for (Map.Entry queryParam : queryParams.entrySet()) {
            builder = builder.queryParam((String)queryParam.getKey(), ((List)queryParam.getValue()).toArray());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getPagedResultsCookie())) {
            result.setNext(builder.replaceQueryParam("connIdPagedResultsCookie", new Object[]{result.getPagedResultsCookie()}).replaceQueryParam("size", new Object[]{query.getSize()}).build(new Object[0]));
        }
        return result;
    }

    public void check(ResourceTO resourceTO) {
        this.logic.check(resourceTO);
    }
}

