/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.data.ImplementationDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ImplementationLogic
extends AbstractTransactionalLogic<ImplementationTO> {
    @Autowired
    private ImplementationDataBinder binder;
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private NotificationDAO notificationDAO;

    @PreAuthorize(value="hasRole('IMPLEMENTATION_LIST')")
    @Transactional(readOnly=true)
    public List<ImplementationTO> list(ImplementationType type) {
        return this.implementationDAO.find(type).stream().map(arg_0 -> ((ImplementationDataBinder)this.binder).getImplementationTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_READ')")
    @Transactional(readOnly=true)
    public ImplementationTO read(ImplementationType type, String key) {
        Implementation implementation = this.implementationDAO.find(key);
        if (implementation == null) {
            LOG.error("Could not find implementation '" + key + "'");
            throw new NotFoundException(key);
        }
        if (implementation.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + implementation.getType());
            throw sce;
        }
        return this.binder.getImplementationTO(implementation);
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_CREATE')")
    public ImplementationTO create(ImplementationTO implementationTO) {
        if (StringUtils.isBlank((CharSequence)implementationTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Implementation key");
            throw sce;
        }
        Implementation implementation = this.implementationDAO.find(implementationTO.getKey());
        if (implementation != null) {
            throw new DuplicateException(implementationTO.getKey());
        }
        return this.binder.getImplementationTO(this.implementationDAO.save(this.binder.create(implementationTO)));
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_UPDATE')")
    public ImplementationTO update(ImplementationTO implementationTO) {
        Implementation implementation = this.implementationDAO.find(implementationTO.getKey());
        if (implementation == null) {
            LOG.error("Could not find implementation '" + implementationTO.getKey() + "'");
            throw new NotFoundException(implementationTO.getKey());
        }
        this.binder.update(implementation, implementationTO);
        implementation = this.implementationDAO.save(implementation);
        return this.binder.getImplementationTO(implementation);
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_DELETE')")
    public void delete(ImplementationType type, String key) {
        Implementation implementation = this.implementationDAO.find(key);
        if (implementation == null) {
            LOG.error("Could not find implementation '" + key + "'");
            throw new NotFoundException(key);
        }
        if (implementation.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + implementation.getType());
            throw sce;
        }
        boolean inUse = false;
        switch (implementation.getType()) {
            case REPORTLET: {
                inUse = !this.reportDAO.findByReportlet(implementation).isEmpty();
                break;
            }
            case ACCOUNT_RULE: {
                inUse = !this.policyDAO.findByAccountRule(implementation).isEmpty();
                break;
            }
            case PASSWORD_RULE: {
                inUse = !this.policyDAO.findByPasswordRule(implementation).isEmpty();
                break;
            }
            case ITEM_TRANSFORMER: {
                inUse = !this.resourceDAO.findByTransformer(implementation).isEmpty();
                break;
            }
            case TASKJOB_DELEGATE: {
                inUse = !this.taskDAO.findByDelegate(implementation).isEmpty();
                break;
            }
            case RECON_FILTER_BUILDER: {
                inUse = !this.taskDAO.findByReconFilterBuilder(implementation).isEmpty();
                break;
            }
            case LOGIC_ACTIONS: {
                inUse = !this.realmDAO.findByLogicActions(implementation).isEmpty();
                break;
            }
            case PROPAGATION_ACTIONS: {
                inUse = !this.resourceDAO.findByPropagationActions(implementation).isEmpty();
                break;
            }
            case PULL_ACTIONS: {
                inUse = !this.taskDAO.findByPullActions(implementation).isEmpty();
                break;
            }
            case PUSH_ACTIONS: {
                inUse = !this.taskDAO.findByPushActions(implementation).isEmpty();
                break;
            }
            case PULL_CORRELATION_RULE: {
                inUse = !this.policyDAO.findByPullCorrelationRule(implementation).isEmpty();
                break;
            }
            case PUSH_CORRELATION_RULE: {
                inUse = !this.policyDAO.findByPushCorrelationRule(implementation).isEmpty();
                break;
            }
            case VALIDATOR: {
                inUse = !this.plainSchemaDAO.findByValidator(implementation).isEmpty();
                break;
            }
            case RECIPIENTS_PROVIDER: {
                inUse = !this.notificationDAO.findByRecipientsProvider(implementation).isEmpty();
                break;
            }
        }
        if (inUse) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InUse);
            sce.getElements().add("This implementation is in use");
            throw sce;
        }
        this.implementationDAO.delete(key);
    }

    @Override
    protected ImplementationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ImplementationTO)) continue;
                key = ((ImplementationTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getImplementationTO(this.implementationDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

