/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.tirasa.connid.bundles.azure.AzureConnector;
import net.tirasa.connid.bundles.azure.dto.AzureObject;
import net.tirasa.connid.bundles.azure.service.AzureService;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

public final class AzureAttributes {
    public static final String USER_ID = "objectId";
    public static final String USER_DISPLAY_NAME = "displayName";
    public static final String USER_PRINCIPAL_NAME = "userPrincipalName";
    public static final String USER_ACCOUNT_ENABLED = "accountEnabled";
    public static final String USER_PASSWORD = "passwordProfile";
    public static final String USER_PASSWORD_PROFILE = "passwordProfile";
    public static final String USER_MAIL_NICKNAME = "mailNickname";
    public static final String GROUP_ID = "objectId";
    public static final String GROUP_DISPLAY_NAME = "displayName";
    public static final String GROUP_MAIL_ENABLED = "mailEnabled";
    public static final String GROUP_MAIL_NICKNAME = "mailNickname";
    public static final String GROUP_SECURITY_ENABLED = "securityEnabled";
    public static final String AZURE_LICENSE_NAME = "azureLicense";
    public static final String USER_USAGE_LOCATION = "usageLocation";
    public static final String SUBSCRIBED_SKU_ID = "objectId";
    public static final List<String> GROUP_REQUIRED_ATTRS = new ArrayList<String>(){
        private static final long serialVersionUID = 3109256773218160485L;
        {
            this.add("displayName");
            this.add(AzureAttributes.GROUP_MAIL_ENABLED);
            this.add("mailNickname");
            this.add(AzureAttributes.GROUP_SECURITY_ENABLED);
        }
    };
    public static final List<String> USER_REQUIRED_ATTRS = new ArrayList<String>(){
        private static final long serialVersionUID = 3109256773218160485L;
        {
            this.add(AzureAttributes.USER_ACCOUNT_ENABLED);
            this.add("displayName");
            this.add("mailNickname");
            this.add("passwordProfile");
            this.add(AzureAttributes.USER_PRINCIPAL_NAME);
        }
    };

    public static Schema buildSchema() {
        SchemaBuilder builder = new SchemaBuilder(AzureConnector.class);
        List<Map<String, String>> userMetadata = AzureService.getMetadata("User");
        List<Map<String, String>> groupMetadata = AzureService.getMetadata("Group");
        ObjectClassInfoBuilder userBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.ACCOUNT_NAME);
        userBuilder.addAttributeInfo(Name.INFO);
        for (Map<String, String> userMetadataElem : userMetadata) {
            String name = userMetadataElem.get("Name");
            String type = userMetadataElem.get("Type");
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)name).setRequired(USER_REQUIRED_ATTRS.contains(name)).setType(AzureAttributes.getCorrectType(type)).setMultiValued(StringUtil.isNotBlank((String)type) && type.contains("Collection")).build());
        }
        ObjectClassInfo user = userBuilder.build();
        builder.defineObjectClass(user);
        ObjectClassInfoBuilder groupBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.GROUP_NAME);
        groupBuilder.addAttributeInfo(Name.INFO);
        for (Map<String, String> groupMetadataElem : groupMetadata) {
            String name = groupMetadataElem.get("Name");
            String type = groupMetadataElem.get("Type");
            groupBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)name).setRequired(GROUP_REQUIRED_ATTRS.contains(name)).setType(AzureAttributes.getCorrectType(type)).setMultiValued(StringUtil.isNotBlank((String)type) && type.contains("Collection")).build());
        }
        ObjectClassInfo group = groupBuilder.build();
        builder.defineObjectClass(group);
        return builder.build();
    }

    public static Class<?> getCorrectType(String type) {
        if (StringUtil.isBlank((String)type)) {
            return String.class;
        }
        Class typeClass = String.class;
        switch (type) {
            case "String": {
                typeClass = String.class;
                break;
            }
            case "Boolean": {
                typeClass = Boolean.class;
                break;
            }
            case "Stream": {
                typeClass = byte[].class;
                break;
            }
        }
        return typeClass;
    }

    public static AttributeBuilder buildAttributeFromClassField(Field field, AzureObject that) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = field.getType();
        Object value = field.get(that);
        AttributeBuilder attributeBuilder = new AttributeBuilder();
        if (value != null) {
            if (clazz == Boolean.TYPE && Boolean.FALSE.equals(value)) {
                attributeBuilder.addValue(new Object[]{value});
            } else {
                attributeBuilder.addValue(new Object[]{value.toString()});
            }
        }
        attributeBuilder.setName(field.getName());
        return attributeBuilder;
    }
}

