/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.soap.to;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import net.tirasa.connid.bundles.soap.to.WSAttribute;
import org.identityconnectors.framework.common.FrameworkUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class WSAttributeValue
extends WSAttribute {
    private static final long serialVersionUID = 8850711594062996107L;
    private List<Object> values = null;
    private List<Object> evaluatedTypeValues = null;

    public WSAttributeValue() {
    }

    public WSAttributeValue(WSAttribute wsAttribute) {
        if (wsAttribute != null) {
            this.setType(wsAttribute.getType());
            this.setName(wsAttribute.getName());
            this.setKey(wsAttribute.isKey());
            this.setNullable(wsAttribute.isNullable());
            this.setPassword(wsAttribute.isPassword());
        }
    }

    public List<Object> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        if (this.evaluatedTypeValues == null) {
            this.evaluatedTypeValues = new ArrayList<Object>();
            for (Object obj : this.values) {
                try {
                    FrameworkUtil.checkAttributeValue((Object)obj);
                    this.getValues().add(obj);
                }
                catch (IllegalArgumentException e) {
                    this.getValues().add(obj.toString());
                }
            }
        }
        return this.evaluatedTypeValues;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public final boolean addValue(Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        return this.values.add(value);
    }

    public String getStringValue() {
        if (this.getType() == null || !"String".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        String res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : this.values.iterator().next().toString();
        return res;
    }

    public Boolean getBooleanValue() {
        if (this.getType() == null || !"Boolean".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Boolean res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Boolean)this.values.iterator().next();
        return res;
    }

    public Long getLongValue() {
        if (this.getType() == null || !"Long".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Long res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Long)this.values.iterator().next();
        return res;
    }

    public Float getFloatValue() {
        if (this.getType() == null || !"Float".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Float res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Float)this.values.iterator().next();
        return res;
    }

    public Double getDoubleValue() {
        if (this.getType() == null || !"Double".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Double res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Double)this.values.iterator().next();
        return res;
    }

    public Integer getIntegerValue() {
        if (this.getType() == null || !"Integer".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Integer res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Integer)this.values.iterator().next();
        return res;
    }

    public Date getDateValue() {
        if (this.getType() == null || !"Date".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Date res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Date)this.values.iterator().next();
        return res;
    }

    public Character getCharacterValue() {
        if (this.getType() == null || !"Character".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        Character res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (Character)this.values.iterator().next();
        return res;
    }

    public URI getURIValue() {
        if (this.getType() == null || !"URI".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        URI res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (URI)this.values.iterator().next();
        return res;
    }

    public File getFileValue() {
        if (this.getType() == null || !"File".equals(this.getType())) {
            throw new IllegalArgumentException("Invalid type declaration");
        }
        File res = this.values == null || this.values.isEmpty() || this.values.iterator().next() == null ? null : (File)this.values.iterator().next();
        return res;
    }
}

