/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.lock;

import java.time.Duration;
import java.util.function.Supplier;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.cmd.GetLockValueCmd;
import org.flowable.common.engine.impl.cmd.LockCmd;
import org.flowable.common.engine.impl.cmd.ReleaseLockCmd;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.lock.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerImpl
implements LockManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LockManagerImpl.class);
    protected CommandExecutor commandExecutor;
    protected String lockName;
    protected Duration lockPollRate;
    protected String engineType;
    protected CommandConfig lockCommandConfig;
    protected boolean hasAcquiredLock;

    public LockManagerImpl(CommandExecutor commandExecutor, String lockName, Duration lockPollRate, String engineType) {
        this.commandExecutor = commandExecutor;
        this.lockName = lockName;
        this.lockPollRate = lockPollRate;
        this.engineType = engineType;
        this.lockCommandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
    }

    @Override
    public void waitForLock(Duration waitTime) {
        long timeToGiveUp = System.currentTimeMillis() + waitTime.toMillis();
        boolean locked = false;
        while (!locked && System.currentTimeMillis() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            try {
                Thread.sleep(this.getLockPollRate().toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!locked) {
            String lockValue = this.executeCommand(new GetLockValueCmd(this.lockName, this.engineType));
            throw new FlowableException("Could not acquire lock " + this.lockName + ". Current lock value: " + lockValue);
        }
    }

    @Override
    public boolean acquireLock() {
        if (this.hasAcquiredLock) {
            return true;
        }
        try {
            this.hasAcquiredLock = this.executeCommand(new LockCmd(this.lockName, this.engineType));
            LOGGER.info("successfully acquired lock {}", (Object)this.lockName);
        }
        catch (FlowableOptimisticLockingException ex) {
            LOGGER.info("failed to acquire lock {} due to optimistic locking", (Object)this.lockName, (Object)ex);
            this.hasAcquiredLock = false;
        }
        return this.hasAcquiredLock;
    }

    @Override
    public void releaseLock() {
        this.executeCommand(new ReleaseLockCmd(this.lockName, this.engineType));
        LOGGER.info("successfully released lock {}", (Object)this.lockName);
        this.hasAcquiredLock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T waitForLockRunAndRelease(Duration waitTime, Supplier<T> supplier) {
        this.waitForLock(waitTime);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.releaseLock();
        }
    }

    protected <T> T executeCommand(Command<T> command) {
        return this.commandExecutor.execute(this.lockCommandConfig, command);
    }

    protected Duration getLockPollRate() {
        return this.lockPollRate;
    }
}

