/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.interceptor.SessionFactory;
import org.flowable.common.engine.impl.runtime.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandContext.class);
    protected Map<String, AbstractEngineConfiguration> engineConfigurations;
    protected Command<?> command;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception;
    protected List<CommandContextCloseListener> closeListeners;
    protected Map<String, Object> attributes;
    protected boolean reused;
    protected LinkedList<Object> resultStack = new LinkedList();
    protected CommandExecutor commandExecutor;
    protected ClassLoader classLoader;
    protected boolean useClassForNameClassLoading;
    protected Clock clock;
    protected ObjectMapper objectMapper;

    public CommandContext(Command<?> command) {
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block25: {
            try {
                try {
                    try {
                        this.executeCloseListenersClosing();
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block25;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.executeCloseListenersAfterSessionFlushed();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                this.logException();
                                this.executeCloseListenersCloseFailure();
                            } else {
                                this.executeCloseListenersClosed();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.executeCloseListenersAfterSessionFlushed();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        this.logException();
                        this.executeCloseListenersCloseFailure();
                    } else {
                        this.executeCloseListenersClosed();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        this.rethrowExceptionIfNeeded();
    }

    protected void logException() {
        if (this.exception instanceof FlowableException && !((FlowableException)this.exception).isLogged()) {
            return;
        }
        if (this.exception instanceof FlowableOptimisticLockingException) {
            LOGGER.debug("Optimistic locking exception : {}", (Object)this.exception.getMessage(), (Object)this.exception);
        } else if (this.exception instanceof FlowableException && ((FlowableException)this.exception).isReduceLogLevel()) {
            LOGGER.info("Error while closing command context", this.exception);
        } else {
            LOGGER.error("Error while closing command context", this.exception);
        }
    }

    protected void rethrowExceptionIfNeeded() throws Error {
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        throw new FlowableException("exception while executing command " + this.command, this.exception);
    }

    public void addCloseListener(CommandContextCloseListener commandContextCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<CommandContextCloseListener>();
        }
        if (!commandContextCloseListener.multipleAllowed()) {
            for (CommandContextCloseListener closeListenerItem : this.closeListeners) {
                if (!closeListenerItem.getClass().equals(commandContextCloseListener.getClass())) continue;
                return;
            }
        }
        this.closeListeners.add(commandContextCloseListener);
        this.closeListeners.sort(Comparator.comparing(CommandContextCloseListener::order));
    }

    public List<CommandContextCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    protected void executeCloseListenersClosing() {
        if (this.closeListeners != null) {
            try {
                for (int i = 0; i < this.closeListeners.size(); ++i) {
                    this.closeListeners.get(i).closing(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersAfterSessionFlushed() {
        if (this.closeListeners != null) {
            try {
                for (int i = 0; i < this.closeListeners.size(); ++i) {
                    this.closeListeners.get(i).afterSessionsFlush(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersClosed() {
        if (this.closeListeners != null) {
            try {
                for (int i = 0; i < this.closeListeners.size(); ++i) {
                    this.closeListeners.get(i).closed(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersCloseFailure() {
        if (this.closeListeners != null) {
            try {
                for (int i = 0; i < this.closeListeners.size(); ++i) {
                    this.closeListeners.get(i).closeFailure(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            LOGGER.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public void resetException() {
        this.exception = null;
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new FlowableException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession(this);
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public void setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    public Map<String, AbstractEngineConfiguration> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfigurations(Map<String, AbstractEngineConfiguration> engineConfigurations) {
        this.engineConfigurations = engineConfigurations;
    }

    public void addEngineConfiguration(String engineKey, String scopeType, AbstractEngineConfiguration engineConfiguration) {
        if (this.engineConfigurations == null) {
            this.engineConfigurations = new HashMap<String, AbstractEngineConfiguration>();
        }
        this.engineConfigurations.put(engineKey, engineConfiguration);
        this.engineConfigurations.put(scopeType, engineConfiguration);
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isUseClassForNameClassLoading() {
        return this.useClassForNameClassLoading;
    }

    public void setUseClassForNameClassLoading(boolean useClassForNameClassLoading) {
        this.useClassForNameClassLoading = useClassForNameClassLoading;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isReused() {
        return this.reused;
    }

    public void setReused(boolean reused) {
        this.reused = reused;
    }

    public Object getResult() {
        return this.resultStack.pollLast();
    }

    public void setResult(Object result) {
        this.resultStack.add(result);
    }
}

