/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.DomainDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Domain;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;

public class AuthDataAccessor {
    protected static final Logger LOG = LoggerFactory.getLogger(AuthDataAccessor.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected static final Set<SyncopeGrantedAuthority> ANONYMOUS_AUTHORITIES = Collections.singleton(new SyncopeGrantedAuthority("ANONYMOUS"));
    protected static final String[] GROUP_OWNER_ENTITLEMENTS = new String[]{"GROUP_READ", "GROUP_UPDATE", "GROUP_DELETE"};
    @Resource(name="adminUser")
    protected String adminUser;
    @Resource(name="anonymousUser")
    protected String anonymousUser;
    @Autowired
    protected DomainDAO domainDAO;
    @Autowired
    protected ConfDAO confDAO;
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected AccessTokenDAO accessTokenDAO;
    @Autowired
    protected ConnectorFactory connFactory;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected MappingManager mappingManager;
    @Autowired
    protected ImplementationLookup implementationLookup;
    private Map<String, JWTSSOProvider> jwtSSOProviders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JWTSSOProvider getJWTSSOProvider(String issuer) {
        AuthDataAccessor authDataAccessor = this;
        synchronized (authDataAccessor) {
            if (this.jwtSSOProviders == null) {
                this.jwtSSOProviders = new HashMap<String, JWTSSOProvider>();
                this.implementationLookup.getJWTSSOProviderClasses().stream().map(clazz -> (JWTSSOProvider)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, true)).forEach(jwtSSOProvider -> this.jwtSSOProviders.put(jwtSSOProvider.getIssuer(), (JWTSSOProvider)jwtSSOProvider));
            }
        }
        if (issuer == null) {
            throw new AuthenticationCredentialsNotFoundException("A null issuer is not permitted");
        }
        JWTSSOProvider provider = this.jwtSSOProviders.get(issuer);
        if (provider == null) {
            throw new AuthenticationCredentialsNotFoundException("Could not find any registered JWTSSOProvider for issuer " + issuer);
        }
        return provider;
    }

    @Transactional(readOnly=true)
    public Domain findDomain(String key) {
        Domain domain = this.domainDAO.find(key);
        if (domain == null) {
            throw new AuthenticationServiceException("Could not find domain " + key);
        }
        return domain;
    }

    @Transactional(noRollbackFor={DisabledException.class})
    public Pair<User, Boolean> authenticate(Authentication authentication) {
        User user = null;
        Optional authAttrs = this.confDAO.find("authentication.attributes");
        List authAttrValues = authAttrs.isPresent() ? ((CPlainAttr)authAttrs.get()).getValuesAsStrings() : Collections.singletonList("username");
        for (int i = 0; user == null && i < authAttrValues.size(); ++i) {
            if ("username".equals(authAttrValues.get(i))) {
                user = this.userDAO.findByUsername(authentication.getName());
                continue;
            }
            AttrCond attrCond = new AttrCond(AttrCond.Type.EQ);
            attrCond.setSchema((String)authAttrValues.get(i));
            attrCond.setExpression(authentication.getName());
            List users = this.searchDAO.search(SearchCond.getLeaf((AbstractSearchCond)attrCond), AnyTypeKind.USER);
            if (users.size() == 1) {
                user = (User)users.get(0);
                continue;
            }
            LOG.warn("Value {} provided for {} does not uniquely identify a user", (Object)authentication.getName(), authAttrValues.get(i));
        }
        Boolean authenticated = null;
        if (user != null) {
            authenticated = false;
            if (user.isSuspended() != null && user.isSuspended().booleanValue()) {
                throw new DisabledException("User " + user.getUsername() + " is suspended");
            }
            if (!this.confDAO.getValuesAsStrings("authentication.statuses").contains(user.getStatus())) {
                throw new DisabledException("User " + user.getUsername() + " not allowed to authenticate");
            }
            boolean userModified = false;
            authenticated = this.authenticate(user, authentication.getCredentials().toString());
            if (authenticated.booleanValue()) {
                if (((Boolean)this.confDAO.find("log.lastlogindate", (Object)true)).booleanValue()) {
                    user.setLastLoginDate(new Date());
                    userModified = true;
                }
                if (user.getFailedLogins() != 0) {
                    user.setFailedLogins(Integer.valueOf(0));
                    userModified = true;
                }
            } else {
                user.setFailedLogins(Integer.valueOf(user.getFailedLogins() + 1));
                userModified = true;
            }
            if (userModified) {
                this.userDAO.save((Any)user);
            }
        }
        return Pair.of(user, (Object)authenticated);
    }

    protected boolean authenticate(User user, String password) {
        boolean authenticated = ENCRYPTOR.verify(password, user.getCipherAlgorithm(), user.getPassword());
        LOG.debug("{} authenticated on internal storage: {}", (Object)user.getUsername(), (Object)authenticated);
        Iterator<? extends ExternalResource> itor = this.getPassthroughResources(user).iterator();
        while (itor.hasNext() && !authenticated) {
            ExternalResource resource = itor.next();
            String connObjectKey = null;
            try {
                AnyType userType = this.anyTypeDAO.findUser();
                Provision provision = (Provision)resource.getProvision(userType).orElseThrow(() -> new AccountNotFoundException("Unable to locate provision for user type " + userType.getKey()));
                connObjectKey = (String)this.mappingManager.getConnObjectKeyValue((Any)user, provision).orElseThrow(() -> new AccountNotFoundException("Unable to locate conn object key value for " + userType.getKey()));
                Uid uid = this.connFactory.getConnector(resource).authenticate(connObjectKey, password, null);
                if (uid != null) {
                    authenticated = true;
                }
            }
            catch (Exception e) {
                LOG.debug("Could not authenticate {} on {}", new Object[]{user.getUsername(), resource.getKey(), e});
            }
            LOG.debug("{} authenticated on {} as {}: {}", new Object[]{user.getUsername(), resource.getKey(), connObjectKey, authenticated});
        }
        return authenticated;
    }

    protected Set<? extends ExternalResource> getPassthroughResources(User user) {
        Set result = null;
        for (ExternalResource resource : this.userDAO.findAllResources(user)) {
            if (resource.getAccountPolicy() == null || resource.getAccountPolicy().getResources().isEmpty()) continue;
            if (result == null) {
                result = resource.getAccountPolicy().getResources();
                continue;
            }
            result.retainAll(resource.getAccountPolicy().getResources());
        }
        for (Realm realm : this.realmDAO.findAncestors(user.getRealm())) {
            if (realm.getAccountPolicy() == null || realm.getAccountPolicy().getResources().isEmpty()) continue;
            if (result == null) {
                result = realm.getAccountPolicy().getResources();
                continue;
            }
            result.retainAll(realm.getAccountPolicy().getResources());
        }
        return result == null ? Collections.emptySet() : result;
    }

    protected Set<SyncopeGrantedAuthority> getAdminAuthorities() {
        return EntitlementsHolder.getInstance().getValues().stream().map(entitlement -> new SyncopeGrantedAuthority((String)entitlement, "/")).collect(Collectors.toSet());
    }

    protected Set<SyncopeGrantedAuthority> getUserAuthorities(User user) {
        HashSet<SyncopeGrantedAuthority> authorities = new HashSet<SyncopeGrantedAuthority>();
        if (user.isMustChangePassword()) {
            authorities.add(new SyncopeGrantedAuthority("MUST_CHANGE_PASSWORD"));
        } else {
            HashMap<String, Set> entForRealms = new HashMap<String, Set>();
            this.userDAO.findAllRoles(user).forEach(role -> role.getEntitlements().forEach(entitlement -> {
                HashSet realms = (HashSet)entForRealms.get(entitlement);
                if (realms == null) {
                    realms = new HashSet();
                    entForRealms.put((String)entitlement, realms);
                }
                realms.addAll(role.getRealms().stream().map(Realm::getFullPath).collect(Collectors.toSet()));
                if (!entitlement.endsWith("_CREATE") && !entitlement.endsWith("_DELETE")) {
                    realms.addAll(role.getDynRealms().stream().map(Entity::getKey).collect(Collectors.toList()));
                }
            }));
            this.groupDAO.findOwnedByUser(user.getKey()).forEach(group -> {
                for (String entitlement : GROUP_OWNER_ENTITLEMENTS) {
                    HashSet<String> realms = (HashSet<String>)entForRealms.get(entitlement);
                    if (realms == null) {
                        realms = new HashSet<String>();
                        entForRealms.put(entitlement, realms);
                    }
                    realms.add(RealmUtils.getGroupOwnerRealm((String)group.getRealm().getFullPath(), (String)group.getKey()));
                }
            });
            entForRealms.forEach((key, value) -> {
                SyncopeGrantedAuthority authority = new SyncopeGrantedAuthority((String)key);
                authority.addRealms(RealmUtils.normalize((Collection)value));
                authorities.add(authority);
            });
        }
        return authorities;
    }

    @Transactional
    public Set<SyncopeGrantedAuthority> getAuthorities(String username) {
        Set<SyncopeGrantedAuthority> authorities;
        if (this.anonymousUser.equals(username)) {
            authorities = ANONYMOUS_AUTHORITIES;
        } else if (this.adminUser.equals(username)) {
            authorities = this.getAdminAuthorities();
        } else {
            User user = this.userDAO.findByUsername(username);
            if (user == null) {
                throw new UsernameNotFoundException("Could not find any user with id " + username);
            }
            authorities = this.getUserAuthorities(user);
        }
        return authorities;
    }

    @Transactional
    public Pair<String, Set<SyncopeGrantedAuthority>> authenticate(JWTAuthentication authentication) {
        Set<SyncopeGrantedAuthority> authorities;
        String username;
        if (this.adminUser.equals(authentication.getClaims().getSubject())) {
            AccessToken accessToken = this.accessTokenDAO.find(authentication.getClaims().getTokenId());
            if (accessToken == null) {
                throw new AuthenticationCredentialsNotFoundException("Could not find an Access Token for JWT " + authentication.getClaims().getTokenId());
            }
            username = this.adminUser;
            authorities = this.getAdminAuthorities();
        } else {
            JWTSSOProvider jwtSSOProvider = this.getJWTSSOProvider(authentication.getClaims().getIssuer());
            Pair<User, Set<SyncopeGrantedAuthority>> resolved = jwtSSOProvider.resolve(authentication.getClaims());
            if (resolved == null || resolved.getLeft() == null) {
                throw new AuthenticationCredentialsNotFoundException("Could not find User " + authentication.getClaims().getSubject() + " for JWT " + authentication.getClaims().getTokenId());
            }
            User user = (User)resolved.getLeft();
            username = user.getUsername();
            authorities = resolved.getRight() == null ? Collections.emptySet() : (Set)resolved.getRight();
            LOG.debug("JWT {} issued by {} resolved to User {} with authorities {}", new Object[]{authentication.getClaims().getTokenId(), authentication.getClaims().getIssuer(), username, authorities});
            if (BooleanUtils.isTrue((Boolean)user.isSuspended())) {
                throw new DisabledException("User " + username + " is suspended");
            }
            if (!this.confDAO.getValuesAsStrings("authentication.statuses").contains(user.getStatus())) {
                throw new DisabledException("User " + username + " not allowed to authenticate");
            }
            if (BooleanUtils.isTrue((Boolean)user.isMustChangePassword())) {
                LOG.debug("User {} must change password, resetting authorities", (Object)username);
                authorities = Collections.singleton(new SyncopeGrantedAuthority("MUST_CHANGE_PASSWORD"));
            }
        }
        return Pair.of((Object)username, authorities);
    }

    @Transactional
    public void removeExpired(String tokenKey) {
        this.accessTokenDAO.delete(tokenKey);
    }

    @Transactional(readOnly=true)
    public void audit(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result result, Object before, Object output, Object ... input) {
        this.auditManager.audit(who, type, category, subcategory, event, result, before, output, input);
    }
}

