/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public final class AuthContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthContextUtils.class);

    public static String getUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication == null ? "unauthenticated" : authentication.getName();
    }

    public static void updateUsername(String newUsername) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)new User(newUsername, "FAKE_PASSWORD", auth.getAuthorities()), auth.getCredentials(), auth.getAuthorities());
        newAuth.setDetails(auth.getDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
    }

    public static Set<SyncopeGrantedAuthority> getAuthorities() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null && ctx.getAuthentication() != null && ctx.getAuthentication().getAuthorities() != null) {
            return ctx.getAuthentication().getAuthorities().stream().filter(SyncopeGrantedAuthority.class::isInstance).map(SyncopeGrantedAuthority.class::cast).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Map<String, Set<String>> getAuthorizations() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null && ctx.getAuthentication() != null && ctx.getAuthentication().getAuthorities() != null) {
            return ctx.getAuthentication().getAuthorities().stream().filter(SyncopeGrantedAuthority.class::isInstance).map(SyncopeGrantedAuthority.class::cast).collect(Collectors.toMap(SyncopeGrantedAuthority::getAuthority, SyncopeGrantedAuthority::getRealms));
        }
        return Collections.emptyMap();
    }

    public static String getDomain() {
        String domainKey;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String string = domainKey = auth != null && auth.getDetails() instanceof SyncopeAuthenticationDetails ? ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(auth.getDetails())).getDomain() : null;
        if (StringUtils.isBlank(domainKey)) {
            domainKey = "Master";
        }
        return domainKey;
    }

    private static Authentication getFakeAuth(String domain) {
        List authorities = EntitlementsHolder.getInstance().getValues().stream().map(entitlement -> new SyncopeGrantedAuthority((String)entitlement, "/")).collect(Collectors.toList());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)new User((String)ApplicationContextProvider.getBeanFactory().getBean("adminUser", String.class), "FAKE_PASSWORD", authorities), (Object)"FAKE_PASSWORD", authorities);
        auth.setDetails((Object)new SyncopeAuthenticationDetails(domain));
        return auth;
    }

    public static <T> T execWithAuthContext(String domain, Executable<T> executable) {
        Authentication original = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(AuthContextUtils.getFakeAuth(domain));
        try {
            T t = executable.exec();
            return t;
        }
        catch (Throwable t) {
            LOG.debug("Error during execution with domain {} context", (Object)domain, (Object)t);
            throw t;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(original);
        }
    }

    private AuthContextUtils() {
    }

    public static interface Executable<T> {
        public T exec();
    }
}

