/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.autocomplete;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.ajax.OnChangeAjaxBehavior;
import com.googlecode.wicket.kendo.ui.form.autocomplete.IAutoCompleteListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;

public abstract class AutoCompleteBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoAutoComplete";
    private final IAutoCompleteListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;
    private KendoDataSource dataSource;

    public AutoCompleteBehavior(String selector, IAutoCompleteListener listener) {
        this(selector, new Options(), listener);
    }

    public AutoCompleteBehavior(String selector, Options options, IAutoCompleteListener listener) {
        super(selector, METHOD, options);
        this.listener = (IAutoCompleteListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource(component);
        this.dataSource.set("serverFiltering", true);
        this.add(this.dataSource);
        this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
        component.add(new Behavior[]{this.onSelectAjaxBehavior});
        if (this.listener.isChangeEventEnabled()) {
            this.onChangeAjaxBehavior = new OnChangeAjaxBehavior(this, new FormComponent[0]);
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    protected abstract CharSequence getDataSourceUrl();

    @Override
    public void onConfigure(Component component) {
        this.setOption("autoBind", true);
        this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
        this.setOption("dataSource", this.dataSource.getName());
        if (this.isEnabled(component)) {
            this.dataSource.setTransportReadUrl(this.getDataSourceUrl());
        }
        this.onConfigure(this.dataSource);
        super.onConfigure(component);
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.listener.onChange(target, ((OnChangeAjaxBehavior.ChangeEvent)event).getValue());
        }
        if (event instanceof SelectEvent) {
            this.listener.onSelect(target, ((SelectEvent)event).getIndex());
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"e.item.index()")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

