/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.rest.api.service.OIDCProviderService;
import org.apache.syncope.core.logic.OIDCProviderLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OIDCProviderServiceImpl
extends AbstractServiceImpl
implements OIDCProviderService {
    @Autowired
    private OIDCProviderLogic logic;

    public Set<String> getActionsClasses() {
        return this.logic.getActionsClasses();
    }

    public Response create(OIDCProviderTO oidcProviderTO) {
        String created = this.logic.create(oidcProviderTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created).build();
    }

    public Response createFromDiscovery(OIDCProviderTO oidcProviderTO) {
        String created = this.logic.createFromDiscovery(oidcProviderTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created).build();
    }

    public List<OIDCProviderTO> list() {
        return this.logic.list();
    }

    public OIDCProviderTO read(String key) {
        return this.logic.read(key);
    }

    public void update(OIDCProviderTO oidcProviderTO) {
        this.logic.update(oidcProviderTO);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

